/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.media.jackson.common;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.helidon.common.GenericType;
import io.helidon.common.http.DataChunk;
import io.helidon.common.http.MediaType;
import io.helidon.common.mapper.Mapper;
import io.helidon.common.reactive.Single;
import io.helidon.media.common.CharBuffer;
import io.helidon.media.common.ContentWriters;
import io.helidon.media.common.MessageBodyWriter;
import io.helidon.media.common.MessageBodyWriterContext;
import io.helidon.media.jackson.common.JacksonRuntimeException;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Objects;
import java.util.concurrent.Flow;
import java.util.function.Function;

public final class JacksonBodyWriter
implements MessageBodyWriter<Object> {
    private final ObjectMapper objectMapper;

    private JacksonBodyWriter(ObjectMapper objectMapper) {
        Objects.requireNonNull(objectMapper);
        this.objectMapper = objectMapper;
    }

    public boolean accept(GenericType<?> type, MessageBodyWriterContext context) {
        return !CharSequence.class.isAssignableFrom(type.rawType()) && this.objectMapper.canSerialize(type.rawType());
    }

    public Flow.Publisher<DataChunk> write(Single<Object> content, GenericType<? extends Object> type, MessageBodyWriterContext context) {
        MediaType contentType = context.findAccepted(MediaType.JSON_PREDICATE, MediaType.APPLICATION_JSON);
        context.contentType(contentType);
        return content.flatMap((Function)((Object)new ObjectToChunks(this.objectMapper, context.charset())));
    }

    public static JacksonBodyWriter create(ObjectMapper objectMapper) {
        return new JacksonBodyWriter(objectMapper);
    }

    private static final class ObjectToChunks
    implements Mapper<Object, Flow.Publisher<DataChunk>> {
        private final ObjectMapper objectMapper;
        private final Charset charset;

        ObjectToChunks(ObjectMapper objectMapper, Charset charset) {
            this.objectMapper = objectMapper;
            this.charset = charset;
        }

        public Flow.Publisher<DataChunk> map(Object content) {
            try {
                CharBuffer buffer = new CharBuffer();
                this.objectMapper.writeValue((Writer)buffer, content);
                return ContentWriters.writeCharBuffer((CharBuffer)buffer, (Charset)this.charset);
            }
            catch (IOException wrapMe) {
                throw new JacksonRuntimeException(wrapMe.getMessage(), wrapMe);
            }
        }
    }
}

