/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.media.jackson.common;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.helidon.common.GenericType;
import io.helidon.common.http.DataChunk;
import io.helidon.common.mapper.Mapper;
import io.helidon.common.reactive.Single;
import io.helidon.media.common.ContentReaders;
import io.helidon.media.common.MessageBodyReader;
import io.helidon.media.common.MessageBodyReaderContext;
import io.helidon.media.jackson.common.JacksonRuntimeException;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Objects;
import java.util.concurrent.Flow;

public final class JacksonBodyReader
implements MessageBodyReader<Object> {
    private final ObjectMapper objectMapper;

    private JacksonBodyReader(ObjectMapper objectMapper) {
        Objects.requireNonNull(objectMapper);
        this.objectMapper = objectMapper;
    }

    public boolean accept(GenericType<?> type, MessageBodyReaderContext context) {
        Class clazz = type.rawType();
        return !CharSequence.class.isAssignableFrom(clazz) && this.objectMapper.canDeserialize(this.objectMapper.constructType((Type)clazz));
    }

    public <U> Single<U> read(Flow.Publisher<DataChunk> publisher, GenericType<U> type, MessageBodyReaderContext context) {
        return ContentReaders.readBytes(publisher).map(new BytesToObject<U>(type, this.objectMapper));
    }

    public static JacksonBodyReader create(ObjectMapper objectMapper) {
        return new JacksonBodyReader(objectMapper);
    }

    private static final class BytesToObject<T>
    implements Mapper<byte[], T> {
        private final GenericType<? super T> type;
        private final ObjectMapper objectMapper;

        BytesToObject(GenericType<T> type, ObjectMapper objectMapper) {
            this.type = type;
            this.objectMapper = objectMapper;
        }

        public T map(byte[] bytes) {
            try {
                return (T)this.objectMapper.readValue(bytes, this.type.rawType());
            }
            catch (IOException wrapMe) {
                throw new JacksonRuntimeException(wrapMe.getMessage(), wrapMe);
            }
        }
    }
}

