/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.media.multipart;

import io.helidon.media.multipart.WriteableBodyPart;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;

public class WriteableMultiPart {
    private final List<WriteableBodyPart> parts;

    WriteableMultiPart(List<WriteableBodyPart> parts) {
        this.parts = parts;
    }

    public List<WriteableBodyPart> bodyParts() {
        return this.parts;
    }

    public static WriteableMultiPart create(WriteableBodyPart ... entities) {
        Builder builder = WriteableMultiPart.builder();
        for (WriteableBodyPart entity : entities) {
            builder.bodyPart(entity);
        }
        return builder.build();
    }

    @SafeVarargs
    public static WriteableMultiPart create(Supplier<WriteableBodyPart> ... suppliers) {
        Builder builder = WriteableMultiPart.builder();
        for (Supplier<WriteableBodyPart> supplier : suppliers) {
            builder.bodyPart(supplier);
        }
        return builder.build();
    }

    public static WriteableMultiPart create(Collection<WriteableBodyPart> entities) {
        Builder builder = WriteableMultiPart.builder();
        for (WriteableBodyPart entity : entities) {
            builder.bodyPart(entity);
        }
        return builder.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    implements io.helidon.common.Builder<Builder, WriteableMultiPart> {
        private final ArrayList<WriteableBodyPart> bodyParts = new ArrayList();

        private Builder() {
        }

        public Builder bodyPart(WriteableBodyPart bodyPart) {
            this.bodyParts.add(bodyPart);
            return this;
        }

        public Builder bodyPart(Supplier<WriteableBodyPart> supplier) {
            return this.bodyPart(supplier.get());
        }

        public Builder bodyPart(String name, Object entity) {
            return this.bodyPart(WriteableBodyPart.builder().name(name).entity(entity).build());
        }

        public Builder bodyPart(String name, String filename, Path file) {
            this.bodyPart(WriteableBodyPart.builder().name(name).filename(filename).entity(file).build());
            return this;
        }

        public Builder bodyPart(String name, Path ... files) {
            for (Path file : files) {
                Path fileName = file.getFileName();
                if (fileName == null) continue;
                this.bodyPart(name, fileName.toString(), file);
            }
            return this;
        }

        public Builder bodyParts(Collection<WriteableBodyPart> bodyParts) {
            this.bodyParts.addAll(bodyParts);
            return this;
        }

        public WriteableMultiPart build() {
            return new WriteableMultiPart(this.bodyParts);
        }
    }
}

