/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.media.multipart;

import io.helidon.common.http.CharMatcher;
import io.helidon.common.http.Http;
import io.helidon.common.http.Tokenizer;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.time.ZonedDateTime;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;

public final class ContentDisposition {
    private static final CharMatcher TOKEN_MATCHER = CharMatcher.ascii().and(CharMatcher.javaIsoControl().negate()).and(CharMatcher.isNot((char)' ')).and(CharMatcher.noneOf((CharSequence)"()<>@,;:\\\"/[]?="));
    private static final CharMatcher LINEAR_WHITE_SPACE = CharMatcher.anyOf((CharSequence)" \t\r\n");
    private static final CharMatcher QUOTED_TEXT_MATCHER = CharMatcher.noneOf((CharSequence)"\"\\\r");
    private static final String NAME_PARAMETER = "name";
    private static final String FILENAME_PARAMETER = "filename";
    private static final String CREATION_DATE_PARAMETER = "creation-date";
    private static final String MODIFICATION_DATE_PARAMETER = "modification-date";
    private static final String READ_DATE_PARAMETER = "read-date";
    private static final String SIZE_PARAMETER = "size";
    static final ContentDisposition EMPTY = new ContentDisposition("", Collections.emptyMap());
    private final String type;
    private final Map<String, String> parameters;

    private ContentDisposition(String type, Map<String, String> params) {
        this.type = type;
        this.parameters = params;
    }

    public String type() {
        return this.type;
    }

    public Optional<String> name() {
        return Optional.ofNullable(this.parameters.get(NAME_PARAMETER));
    }

    public Optional<String> filename() {
        String filename = null;
        String value = this.parameters.get(FILENAME_PARAMETER);
        if (value != null) {
            filename = URLDecoder.decode(value, StandardCharsets.UTF_8);
        }
        return Optional.ofNullable(filename);
    }

    public Optional<ZonedDateTime> creationDate() {
        return Optional.ofNullable(this.parameters.get(CREATION_DATE_PARAMETER)).map(Http.DateTime::parse);
    }

    public Optional<ZonedDateTime> modificationDate() {
        return Optional.ofNullable(this.parameters.get(MODIFICATION_DATE_PARAMETER)).map(Http.DateTime::parse);
    }

    public Optional<ZonedDateTime> readDate() {
        return Optional.ofNullable(this.parameters.get(READ_DATE_PARAMETER)).map(Http.DateTime::parse);
    }

    public OptionalLong size() {
        String size = this.parameters.get(SIZE_PARAMETER);
        if (size != null) {
            return OptionalLong.of(Long.parseLong(size));
        }
        return OptionalLong.empty();
    }

    public Map<String, String> parameters() {
        return this.parameters;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.type);
        for (Map.Entry<String, String> param : this.parameters.entrySet()) {
            sb.append(";");
            sb.append(param.getKey());
            sb.append("=");
            if (SIZE_PARAMETER.equals(param.getKey())) {
                sb.append(param.getValue());
                continue;
            }
            sb.append("\"");
            sb.append(param.getValue());
            sb.append("\"");
        }
        return sb.toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    static ContentDisposition parse(String input) {
        Objects.requireNonNull(input, "Parameter 'input' is null!");
        Tokenizer tokenizer = new Tokenizer(input.trim());
        try {
            String type = tokenizer.consumeToken(TOKEN_MATCHER).toLowerCase();
            HashMap<String, String> parameters = new HashMap<String, String>();
            while (tokenizer.hasMore()) {
                String value;
                tokenizer.consumeTokenIfPresent(LINEAR_WHITE_SPACE);
                tokenizer.consumeCharacter(';');
                tokenizer.consumeTokenIfPresent(LINEAR_WHITE_SPACE);
                String attribute = tokenizer.consumeToken(TOKEN_MATCHER);
                tokenizer.consumeCharacter('=');
                if ('\"' == tokenizer.previewChar()) {
                    tokenizer.consumeCharacter('\"');
                    StringBuilder valueBuilder = new StringBuilder();
                    while ('\"' != tokenizer.previewChar()) {
                        if ('\\' == tokenizer.previewChar()) {
                            tokenizer.consumeCharacter('\\');
                            char c = tokenizer.previewChar();
                            if ('\"' == c || '\\' == c) {
                                valueBuilder.append(tokenizer.consumeCharacter(CharMatcher.ascii()));
                                continue;
                            }
                            valueBuilder.append('\\');
                        }
                        valueBuilder.append(tokenizer.consumeToken(QUOTED_TEXT_MATCHER));
                    }
                    value = valueBuilder.toString();
                    tokenizer.consumeCharacter('\"');
                } else {
                    value = tokenizer.consumeToken(TOKEN_MATCHER);
                }
                parameters.put(attribute, value);
            }
            return new ContentDisposition(type, parameters);
        }
        catch (IllegalStateException e) {
            throw new IllegalArgumentException("Could not parse '" + input + "'", e);
        }
    }

    public static final class Builder
    implements io.helidon.common.Builder<Builder, ContentDisposition> {
        private String type = "form-data";
        private final Map<String, String> params = new HashMap<String, String>();

        public Builder type(String type) {
            this.type = type;
            return this;
        }

        public Builder name(String name) {
            this.params.put(ContentDisposition.NAME_PARAMETER, name);
            return this;
        }

        public Builder filename(String filename) {
            this.params.put(ContentDisposition.FILENAME_PARAMETER, URLEncoder.encode(filename, StandardCharsets.UTF_8));
            return this;
        }

        public Builder creationDate(ZonedDateTime date) {
            this.params.put(ContentDisposition.CREATION_DATE_PARAMETER, date.format(Http.DateTime.RFC_1123_DATE_TIME));
            return this;
        }

        public Builder modificationDate(ZonedDateTime date) {
            this.params.put(ContentDisposition.MODIFICATION_DATE_PARAMETER, date.format(Http.DateTime.RFC_1123_DATE_TIME));
            return this;
        }

        public Builder readDate(ZonedDateTime date) {
            this.params.put(ContentDisposition.READ_DATE_PARAMETER, date.format(Http.DateTime.RFC_1123_DATE_TIME));
            return this;
        }

        public Builder size(long size) {
            this.params.put(ContentDisposition.SIZE_PARAMETER, Long.toString(size));
            return this;
        }

        public Builder parameter(String name, String value) {
            this.params.put(name, value);
            return this;
        }

        public ContentDisposition build() {
            return new ContentDisposition(this.type, this.params);
        }
    }
}

