/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.media.multipart;

import io.helidon.common.GenericType;
import io.helidon.common.http.DataChunk;
import io.helidon.common.http.MediaType;
import io.helidon.media.common.MessageBodyOperator;
import io.helidon.media.common.MessageBodyStreamWriter;
import io.helidon.media.common.MessageBodyWriterContext;
import io.helidon.media.multipart.MultiPartEncoder;
import io.helidon.media.multipart.WriteableBodyPart;
import java.util.concurrent.Flow;

public final class BodyPartBodyStreamWriter
implements MessageBodyStreamWriter<WriteableBodyPart> {
    private final String boundary;

    private BodyPartBodyStreamWriter(String boundary) {
        this.boundary = boundary;
    }

    public MessageBodyOperator.PredicateResult accept(GenericType<?> type, MessageBodyWriterContext context) {
        return MessageBodyOperator.PredicateResult.supports(WriteableBodyPart.class, type);
    }

    public Flow.Publisher<DataChunk> write(Flow.Publisher<? extends WriteableBodyPart> content, GenericType<? extends WriteableBodyPart> type, MessageBodyWriterContext context) {
        context.contentType(MediaType.MULTIPART_FORM_DATA);
        MultiPartEncoder encoder = MultiPartEncoder.create(this.boundary, context);
        content.subscribe(encoder);
        return encoder;
    }

    public static BodyPartBodyStreamWriter create() {
        return new BodyPartBodyStreamWriter("[^._.^]==>boundary<==[^._.^]");
    }

    public static BodyPartBodyStreamWriter create(String boundary) {
        return new BodyPartBodyStreamWriter(boundary);
    }
}

