/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.media.multipart;

import io.helidon.common.http.MediaType;
import io.helidon.common.http.ReadOnlyHeaders;
import io.helidon.media.multipart.BodyPartHeaders;
import io.helidon.media.multipart.ContentDisposition;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public final class ReadableBodyPartHeaders
extends ReadOnlyHeaders
implements BodyPartHeaders {
    private final Object internalLock = new Object();
    private ContentDisposition contentDisposition;

    private ReadableBodyPartHeaders(Map<String, List<String>> params) {
        super(params);
    }

    @Override
    public MediaType contentType() {
        return this.first("Content-Type").map(MediaType::parse).orElseGet(this::defaultContentType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ContentDisposition contentDisposition() {
        if (this.contentDisposition == null) {
            Object object = this.internalLock;
            synchronized (object) {
                this.contentDisposition = this.first("Content-Disposition").map(ContentDisposition::parse).orElse(ContentDisposition.EMPTY);
            }
        }
        return this.contentDisposition;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static ReadableBodyPartHeaders create() {
        return new ReadableBodyPartHeaders(null);
    }

    public static final class Builder
    implements io.helidon.common.Builder<Builder, ReadableBodyPartHeaders> {
        private final Map<String, List<String>> headers = new TreeMap<String, List<String>>(String.CASE_INSENSITIVE_ORDER);

        private Builder() {
        }

        Builder header(String name, String value) {
            List<String> values = this.headers.get(name);
            if (values == null) {
                values = new ArrayList<String>();
                this.headers.put(name, values);
            }
            values.add(value);
            return this;
        }

        public ReadableBodyPartHeaders build() {
            return new ReadableBodyPartHeaders(this.headers);
        }
    }
}

