/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.media.multipart;

import io.helidon.common.http.DataChunk;
import io.helidon.common.http.ReadOnlyParameters;
import io.helidon.common.reactive.Multi;
import io.helidon.common.reactive.SubscriptionHelper;
import io.helidon.media.common.MessageBodyReadableContent;
import io.helidon.media.common.MessageBodyReaderContext;
import io.helidon.media.multipart.BodyPartChunk;
import io.helidon.media.multipart.MimeParser;
import io.helidon.media.multipart.ReadableBodyPart;
import io.helidon.media.multipart.ReadableBodyPartHeaders;
import io.helidon.media.multipart.VirtualBuffer;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Flow;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class MultiPartDecoder
implements Flow.Processor<DataChunk, ReadableBodyPart> {
    private static final int DOWNSTREAM_INIT = 0x40000000;
    private static final int UPSTREAM_INIT = 0x20000000;
    private static final int SUBSCRIPTION_LOCK = 0x10000000;
    private static final Iterator<VirtualBuffer.BufferEntry> EMPTY_BUFFER_ENTRY_ITERATOR = new EmptyIterator<VirtualBuffer.BufferEntry>();
    private static final Iterator<MimeParser.ParserEvent> EMPTY_PARSER_ITERATOR = new EmptyIterator<MimeParser.ParserEvent>();
    private volatile Flow.Subscription upstream;
    private Flow.Subscriber<? super ReadableBodyPart> downstream;
    private ReadableBodyPart.Builder bodyPartBuilder;
    private ReadableBodyPartHeaders.Builder bodyPartHeaderBuilder;
    private DataChunkPublisher bodyPartPublisher;
    private Iterator<MimeParser.ParserEvent> parserIterator = EMPTY_PARSER_ITERATOR;
    private volatile Throwable error;
    private boolean cancelled;
    private AtomicInteger contenders = new AtomicInteger(Integer.MIN_VALUE);
    private AtomicLong partsRequested = new AtomicLong();
    private final HashMap<Integer, DataChunk> chunksByIds;
    private final MimeParser parser;
    private final MessageBodyReaderContext context;

    MultiPartDecoder(String boundary, MessageBodyReaderContext context) {
        Objects.requireNonNull(boundary, "boundary cannot be null!");
        Objects.requireNonNull(context, "context cannot be null!");
        this.context = context;
        this.parser = new MimeParser(boundary);
        this.chunksByIds = new HashMap();
    }

    public static MultiPartDecoder create(String boundary, MessageBodyReaderContext context) {
        return new MultiPartDecoder(boundary, context);
    }

    @Override
    public void subscribe(Flow.Subscriber<? super ReadableBodyPart> subscriber) {
        Objects.requireNonNull(subscriber);
        if (!this.halfInit(0x20000000)) {
            Multi.error((Throwable)new IllegalStateException("Only one Subscriber allowed")).subscribe(subscriber);
            return;
        }
        this.downstream = subscriber;
        this.downstream.onSubscribe(new Flow.Subscription(){

            @Override
            public void request(long n) {
                long curr;
                long l = curr = n <= 0L ? MultiPartDecoder.this.partsRequested.getAndSet(-1L) : MultiPartDecoder.this.partsRequested.getAndUpdate(v -> Long.MAX_VALUE - v > n ? v + n : (v < 0L ? v : Long.MAX_VALUE));
                if (curr == 0L) {
                    MultiPartDecoder.this.drain();
                }
            }

            @Override
            public void cancel() {
                MultiPartDecoder.this.cancelled = true;
                if (MultiPartDecoder.this.partsRequested.getAndSet(-1L) == 0L) {
                    MultiPartDecoder.this.drain();
                }
            }
        });
        this.deferredInit();
    }

    @Override
    public void onSubscribe(Flow.Subscription subscription) {
        if (!this.halfInit(0x40000000)) {
            SubscriptionHelper.validate((Flow.Subscription)this.upstream, (Flow.Subscription)subscription);
            return;
        }
        this.upstream = subscription;
        this.deferredInit();
    }

    @Override
    public void onNext(DataChunk chunk) {
        try {
            ByteBuffer[] byteBuffers = chunk.data();
            for (int i = 0; i < byteBuffers.length; ++i) {
                int id = this.parser.offer(byteBuffers[i]);
                if (i != byteBuffers.length - 1) continue;
                this.chunksByIds.put(id, chunk);
            }
            this.parserIterator = this.parser.parseIterator();
            this.drain();
        }
        catch (MimeParser.ParsingException ex) {
            this.drain(ex);
        }
    }

    @Override
    public void onError(Throwable throwable) {
        Objects.requireNonNull(throwable);
        this.error = throwable;
        if (this.upstream != SubscriptionHelper.CANCELED) {
            this.upstream = SubscriptionHelper.CANCELED;
            this.drain();
        }
    }

    @Override
    public void onComplete() {
        if (this.upstream != SubscriptionHelper.CANCELED) {
            this.upstream = SubscriptionHelper.CANCELED;
            this.drain();
        }
    }

    private boolean halfInit(int mask) {
        int c = this.contenders.getAndUpdate(v -> v < 0 ? v | mask : v);
        return c < 0 && (c & mask) == 0;
    }

    private void deferredInit() {
        if (this.contenders.addAndGet(0x10000000) > 0) {
            this.drainLoop();
        }
    }

    private long partsRequested() {
        return this.bodyPartPublisher != null ? 1L : this.partsRequested.get();
    }

    private void cleanup() {
        this.parserIterator = EMPTY_PARSER_ITERATOR;
        this.error = null;
        this.upstream = SubscriptionHelper.CANCELED;
        this.downstream = null;
        this.cancelled = true;
        this.bodyPartHeaderBuilder = null;
        this.bodyPartBuilder = null;
        this.partsRequested.set(-1L);
        this.releaseChunks();
        this.parser.cleanup();
    }

    protected void drain() {
        if (this.contenders.getAndIncrement() != 0) {
            return;
        }
        this.drainLoop();
    }

    protected void drainLoop() {
        int c = 1;
        while (c > 0) {
            this.drainBoth();
            c = this.contenders.addAndGet(-c);
        }
    }

    protected void drain(Throwable th) {
        this.error = th;
        this.drain();
    }

    protected void drainBoth() {
        if (this.bodyPartPublisher != null && !this.bodyPartPublisher.drain()) {
            return;
        }
        try {
            long requested = this.partsRequested();
            while (requested >= 0L && this.parserIterator.hasNext()) {
                if (requested == 0L) {
                    return;
                }
                MimeParser.ParserEvent event = this.parserIterator.next();
                switch (event.type()) {
                    case START_PART: {
                        this.bodyPartHeaderBuilder = ReadableBodyPartHeaders.builder();
                        this.bodyPartBuilder = ReadableBodyPart.builder();
                        break;
                    }
                    case HEADER: {
                        MimeParser.HeaderEvent headerEvent = event.asHeaderEvent();
                        this.bodyPartHeaderBuilder.header(headerEvent.name(), headerEvent.value());
                        break;
                    }
                    case END_HEADERS: {
                        this.bodyPartPublisher = new DataChunkPublisher();
                        this.downstream.onNext(this.createPart());
                        this.bodyPartHeaderBuilder = null;
                        this.bodyPartBuilder = null;
                        return;
                    }
                    case BODY: {
                        Iterator<VirtualBuffer.BufferEntry> bodyIterator = event.asBodyEvent().body().iterator();
                        this.bodyPartPublisher.nextIterator(bodyIterator);
                        if (this.bodyPartPublisher.drain()) break;
                        return;
                    }
                    case END_PART: {
                        this.bodyPartPublisher.complete(null);
                        this.bodyPartPublisher = null;
                        requested = this.partsRequested.updateAndGet(v -> v == Long.MAX_VALUE || v < 0L ? v : v - 1L);
                        break;
                    }
                }
            }
            if (requested < 0L) {
                if (this.cancelled) {
                    this.upstream.cancel();
                    this.cleanup();
                    return;
                }
                this.error = new IllegalArgumentException("Expecting only positive requests for parts");
            }
            if (this.upstream == SubscriptionHelper.CANCELED || this.error != null) {
                if (this.error != null) {
                    if (this.bodyPartPublisher != null) {
                        this.bodyPartPublisher.complete(this.error);
                        this.bodyPartPublisher = null;
                    }
                    this.upstream.cancel();
                    this.downstream.onError(this.error);
                } else {
                    this.parser.close();
                    this.downstream.onComplete();
                }
                this.cleanup();
                return;
            }
            this.parserIterator = EMPTY_PARSER_ITERATOR;
            if (requested > 0L) {
                this.upstream.request(1L);
            }
        }
        catch (MimeParser.ParsingException ex) {
            this.parserIterator = EMPTY_PARSER_ITERATOR;
            this.drain(ex);
        }
    }

    private void releaseChunks() {
        Iterator<DataChunk> it = this.chunksByIds.values().iterator();
        while (it.hasNext()) {
            DataChunk next = it.next();
            next.release();
            it.remove();
        }
    }

    private ReadableBodyPart createPart() {
        ReadableBodyPartHeaders headers = this.bodyPartHeaderBuilder.build();
        MessageBodyReaderContext partContext = MessageBodyReaderContext.create((MessageBodyReaderContext)this.context, null, (ReadOnlyParameters)headers, Optional.of(headers.contentType()));
        MessageBodyReadableContent partContent = MessageBodyReadableContent.create((Flow.Publisher)this.bodyPartPublisher, (MessageBodyReaderContext)partContext);
        return this.bodyPartBuilder.headers(headers).content(partContent).build();
    }

    private BodyPartChunk createPartChunk(VirtualBuffer.BufferEntry entry) {
        boolean release;
        ByteBuffer data = entry.buffer();
        int id = entry.id();
        DataChunk chunk = this.chunksByIds.get(id);
        if (chunk == null) {
            throw new IllegalStateException("Parent chunk not found, id=" + id);
        }
        ByteBuffer[] originalBuffers = chunk.data();
        boolean bl = release = data.limit() == originalBuffers[originalBuffers.length - 1].limit();
        if (release) {
            this.chunksByIds.remove(id);
        }
        return new BodyPartChunk(data, (DataChunk)(release ? chunk : null));
    }

    protected final class DataChunkPublisher
    implements Flow.Publisher<DataChunk> {
        private final AtomicLong chunksRequested = new AtomicLong(-9223372036854775807L);
        private Iterator<VirtualBuffer.BufferEntry> bufferEntryIterator = EMPTY_BUFFER_ENTRY_ITERATOR;
        private boolean cancelled;
        private Flow.Subscriber<? super DataChunk> subscriber;

        protected DataChunkPublisher() {
        }

        @Override
        public void subscribe(Flow.Subscriber<? super DataChunk> sub) {
            if (!this.chunksRequested.compareAndSet(-9223372036854775807L, Long.MIN_VALUE)) {
                Multi.error((Throwable)new IllegalStateException("Only one Subscriber allowed")).subscribe(this.subscriber);
                return;
            }
            this.subscriber = sub;
            sub.onSubscribe(new Flow.Subscription(){

                @Override
                public void request(long n) {
                    long curr;
                    long l = curr = n <= 0L ? DataChunkPublisher.this.chunksRequested.getAndSet(-1L) : DataChunkPublisher.this.chunksRequested.getAndUpdate(v -> Long.MAX_VALUE - v > n ? v + n : (v < 0L ? (v == Long.MIN_VALUE ? n : v) : Long.MAX_VALUE));
                    if (curr == 0L) {
                        MultiPartDecoder.this.drain();
                    }
                }

                @Override
                public void cancel() {
                    DataChunkPublisher.this.cancelled = true;
                    if (DataChunkPublisher.this.chunksRequested.getAndSet(-1L) == 0L) {
                        MultiPartDecoder.this.drain();
                    }
                }
            });
            if (this.chunksRequested.compareAndSet(Long.MIN_VALUE, 0L)) {
                return;
            }
            MultiPartDecoder.this.drain();
        }

        void nextIterator(Iterator<VirtualBuffer.BufferEntry> iterator) {
            this.bufferEntryIterator = iterator;
        }

        void complete(Throwable th) {
            if (this.chunksRequested.get() < 0L) {
                if (this.cancelled) {
                    this.subscriber = null;
                    return;
                }
                th = new IllegalArgumentException("Expecting only positive requests");
            }
            this.cancelled = true;
            this.chunksRequested.set(-1L);
            if (th != null) {
                this.subscriber.onError(th);
            } else {
                this.subscriber.onComplete();
            }
            this.subscriber = null;
        }

        boolean drain() {
            long requested = this.chunksRequested.get();
            long chunksEmitted = 0L;
            while (chunksEmitted < requested && this.bufferEntryIterator.hasNext()) {
                do {
                    BodyPartChunk chunk = MultiPartDecoder.this.createPartChunk(this.bufferEntryIterator.next());
                    this.subscriber.onNext(chunk);
                    chunk.release();
                } while (++chunksEmitted < requested && this.bufferEntryIterator.hasNext());
                long ce = chunksEmitted;
                requested = this.chunksRequested.updateAndGet(v -> v == Long.MAX_VALUE || v < 0L ? v : v - ce);
                chunksEmitted = 0L;
            }
            if (requested < 0L) {
                while (this.bufferEntryIterator.hasNext()) {
                    MultiPartDecoder.this.createPartChunk(this.bufferEntryIterator.next()).release();
                }
            }
            if (requested != 0L) {
                this.bufferEntryIterator = EMPTY_BUFFER_ENTRY_ITERATOR;
                return true;
            }
            return false;
        }
    }

    private static final class EmptyIterator<T>
    implements Iterator<T> {
        private EmptyIterator() {
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public T next() {
            throw new IllegalStateException("Read beyond EOF");
        }
    }
}

