/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.media.multipart;

import io.helidon.common.GenericType;
import io.helidon.common.http.DataChunk;
import io.helidon.common.mapper.Mapper;
import io.helidon.common.reactive.Collector;
import io.helidon.common.reactive.Multi;
import io.helidon.common.reactive.Single;
import io.helidon.media.common.ContentReaders;
import io.helidon.media.common.ContentWriters;
import io.helidon.media.common.MessageBodyOperator;
import io.helidon.media.common.MessageBodyReadableContent;
import io.helidon.media.common.MessageBodyReader;
import io.helidon.media.common.MessageBodyReaderContext;
import io.helidon.media.multipart.MultiPart;
import io.helidon.media.multipart.MultiPartDecoder;
import io.helidon.media.multipart.ReadableBodyPart;
import io.helidon.media.multipart.ReadableMultiPart;
import java.util.LinkedList;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Flow;
import java.util.function.Function;

public final class MultiPartBodyReader
implements MessageBodyReader<MultiPart> {
    private static final BytesToChunks BYTES_TO_CHUNKS = new BytesToChunks();

    private MultiPartBodyReader() {
    }

    public MessageBodyOperator.PredicateResult accept(GenericType<?> type, MessageBodyReaderContext ctx) {
        return MessageBodyOperator.PredicateResult.supports(MultiPart.class, type);
    }

    public <U extends MultiPart> Single<U> read(Flow.Publisher<DataChunk> publisher, GenericType<U> type, MessageBodyReaderContext context) {
        String boundary = context.contentType().map(ct -> (String)ct.parameters().get("boundary")).orElseThrow(() -> new IllegalStateException("boundary header is missing"));
        MultiPartDecoder decoder = MultiPartDecoder.create(boundary, context);
        publisher.subscribe(decoder);
        return Multi.create((Flow.Publisher)decoder).collect((Collector)new PartsCollector());
    }

    public static MultiPartBodyReader create() {
        return new MultiPartBodyReader();
    }

    private static final class PartsCollector
    implements Collector<ReadableBodyPart, ReadableMultiPart> {
        private final LinkedList<ReadableBodyPart> bodyParts = new LinkedList();

        PartsCollector() {
        }

        public void collect(ReadableBodyPart bodyPart) {
            MessageBodyReadableContent content = bodyPart.content();
            Multi bufferedData = Single.create((CompletionStage)ContentReaders.readBytes((Flow.Publisher)content).toStage()).flatMap((Function)((Object)BYTES_TO_CHUNKS));
            MessageBodyReadableContent contentCopy = MessageBodyReadableContent.create((Flow.Publisher)bufferedData, (MessageBodyReaderContext)content.readerContext());
            ReadableBodyPart bufferedBodyPart = ReadableBodyPart.builder().headers(bodyPart.headers()).content(contentCopy).buffered().build();
            this.bodyParts.add(bufferedBodyPart);
        }

        public ReadableMultiPart value() {
            return new ReadableMultiPart(this.bodyParts);
        }
    }

    private static final class BytesToChunks
    implements Mapper<byte[], Flow.Publisher<DataChunk>> {
        private BytesToChunks() {
        }

        public Flow.Publisher<DataChunk> map(byte[] bytes) {
            return ContentWriters.writeBytes((byte[])bytes, (boolean)true);
        }
    }
}

