/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.media.multipart;

import io.helidon.common.http.DataChunk;
import io.helidon.media.common.MessageBodyReadableContent;
import io.helidon.media.multipart.BodyPart;
import io.helidon.media.multipart.ReadableBodyPartHeaders;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.function.Supplier;

public final class ReadableBodyPart
implements BodyPart {
    private final MessageBodyReadableContent content;
    private final ReadableBodyPartHeaders headers;
    private final boolean buffered;

    private ReadableBodyPart(MessageBodyReadableContent content, ReadableBodyPartHeaders headers, boolean buffered) {
        this.content = content;
        this.headers = headers;
        this.buffered = buffered;
    }

    public MessageBodyReadableContent content() {
        return this.content;
    }

    public void drain() {
        this.content().forEach(DataChunk::release);
    }

    @Override
    public ReadableBodyPartHeaders headers() {
        return this.headers;
    }

    public boolean isBuffered() {
        return this.buffered;
    }

    public <T> T as(Class<T> clazz) {
        if (!this.buffered) {
            throw new IllegalStateException("The content of this part is not buffered");
        }
        CompletableFuture future = this.content.as(clazz).toCompletableFuture();
        if (!future.isDone()) {
            throw new IllegalStateException("Unable to convert part content synchronously");
        }
        try {
            return future.get();
        }
        catch (InterruptedException | ExecutionException ex) {
            throw new IllegalStateException(ex.getMessage(), ex);
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    implements io.helidon.common.Builder<ReadableBodyPart> {
        private ReadableBodyPartHeaders headers;
        private MessageBodyReadableContent content;
        private boolean buffered;

        private Builder() {
        }

        public Builder content(MessageBodyReadableContent content) {
            this.content = content;
            return this;
        }

        public Builder buffered() {
            this.buffered = true;
            return this;
        }

        public Builder headers(ReadableBodyPartHeaders headers) {
            this.headers = headers;
            return this;
        }

        public Builder headers(Supplier<ReadableBodyPartHeaders> supplier) {
            this.headers = supplier.get();
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            this.headers = ReadableBodyPartHeaders.builder().headers(headers).build();
            return this;
        }

        public ReadableBodyPart build() {
            if (this.headers == null) {
                this.headers = ReadableBodyPartHeaders.create();
            }
            if (this.content == null) {
                throw new IllegalStateException("content is required");
            }
            return new ReadableBodyPart(this.content, this.headers, this.buffered);
        }
    }
}

