/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.media.multipart;

import io.helidon.common.GenericType;
import io.helidon.common.http.DataChunk;
import io.helidon.common.http.Parameters;
import io.helidon.common.reactive.Single;
import io.helidon.common.reactive.SubscriptionHelper;
import io.helidon.media.common.MessageBodyWriterContext;
import io.helidon.media.multipart.BodyPart;
import io.helidon.media.multipart.WriteableBodyPartContent;
import io.helidon.media.multipart.WriteableBodyPartHeaders;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Flow;
import java.util.function.Supplier;

public final class WriteableBodyPart
implements BodyPart {
    private final WriteableBodyPartContent content;
    private final WriteableBodyPartHeaders headers;

    private WriteableBodyPart(WriteableBodyPartContent content, WriteableBodyPartHeaders headers) {
        this.content = content;
        this.headers = headers;
    }

    @Override
    public WriteableBodyPartContent content() {
        return this.content;
    }

    @Override
    public WriteableBodyPartHeaders headers() {
        return this.headers;
    }

    public static WriteableBodyPart create(Object entity) {
        return WriteableBodyPart.builder().entity(entity).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static final class EntityStreamBodyPartContent<T>
    implements WriteableBodyPartContent {
        private final Flow.Publisher<T> stream;
        private final GenericType<T> type;
        private final Parameters headers;
        private Flow.Publisher<DataChunk> publisher;

        EntityStreamBodyPartContent(Flow.Publisher<T> stream, GenericType<T> type, Parameters headers) {
            this.stream = Objects.requireNonNull(stream, "entity cannot be null!");
            this.type = Objects.requireNonNull(type, "type cannot be null!");
            this.headers = Objects.requireNonNull(headers, "headers cannot be null");
        }

        @Override
        public WriteableBodyPartContent init(MessageBodyWriterContext context) {
            this.publisher = MessageBodyWriterContext.create((Parameters)this.headers).marshallStream(this.stream, this.type);
            return this;
        }

        public void subscribe(Flow.Subscriber<? super DataChunk> subscriber) {
            if (this.publisher == null) {
                subscriber.onSubscribe((Flow.Subscription)SubscriptionHelper.CANCELED);
                subscriber.onError(new IllegalStateException("Not ready yet"));
                return;
            }
            this.publisher.subscribe(subscriber);
        }
    }

    private static final class EntityBodyPartContent
    implements WriteableBodyPartContent {
        private final Object entity;
        private final GenericType<Object> type;
        private final Parameters headers;
        private Flow.Publisher<DataChunk> publisher;

        EntityBodyPartContent(Object entity, Parameters headers) {
            this.entity = Objects.requireNonNull(entity, "entity cannot be null!");
            this.headers = Objects.requireNonNull(headers, "headers cannot be null");
            this.type = GenericType.create(entity.getClass());
        }

        @Override
        public WriteableBodyPartContent init(MessageBodyWriterContext context) {
            this.publisher = MessageBodyWriterContext.create((MessageBodyWriterContext)context, (Parameters)this.headers).marshall(Single.just((Object)this.entity), this.type);
            return this;
        }

        public void subscribe(Flow.Subscriber<? super DataChunk> subscriber) {
            if (this.publisher == null) {
                subscriber.onSubscribe((Flow.Subscription)SubscriptionHelper.CANCELED);
                subscriber.onError(new IllegalStateException("Not ready yet"));
                return;
            }
            this.publisher.subscribe(subscriber);
        }
    }

    private static final class RawBodyPartContent
    implements WriteableBodyPartContent {
        private final Flow.Publisher<DataChunk> publisher;

        RawBodyPartContent(Flow.Publisher<DataChunk> publisher) {
            this.publisher = Objects.requireNonNull(publisher, "entity cannot be null!");
        }

        @Override
        public WriteableBodyPartContent init(MessageBodyWriterContext context) {
            return this;
        }

        public void subscribe(Flow.Subscriber<? super DataChunk> subscriber) {
            this.publisher.subscribe(subscriber);
        }
    }

    public static final class Builder
    implements io.helidon.common.Builder<WriteableBodyPart> {
        private static final WriteableBodyPartContent EMPTY_BODY_CONTENT = new RawBodyPartContent((Flow.Publisher<DataChunk>)Single.empty());
        private WriteableBodyPartHeaders headers = WriteableBodyPartHeaders.create();
        private WriteableBodyPartContent content = EMPTY_BODY_CONTENT;
        private String name;
        private String fileName;

        private Builder() {
        }

        public Builder entity(Object entity) {
            this.content = new EntityBodyPartContent(entity, (Parameters)this.headers);
            return this;
        }

        public <T> Builder entityStream(Flow.Publisher<T> stream, Class<T> type) {
            Objects.requireNonNull(type, "type cannot be null!");
            this.content = new EntityStreamBodyPartContent<T>(stream, GenericType.create(type), (Parameters)this.headers);
            return this;
        }

        public Builder publisher(Flow.Publisher<DataChunk> publisher) {
            this.content = new RawBodyPartContent(publisher);
            return this;
        }

        public Builder headers(WriteableBodyPartHeaders headers) {
            this.headers = headers;
            return this;
        }

        public Builder headers(Supplier<WriteableBodyPartHeaders> supplier) {
            this.headers = supplier.get();
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            this.headers = WriteableBodyPartHeaders.builder().headers(headers).build();
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder filename(String fileName) {
            this.fileName = fileName;
            return this;
        }

        public WriteableBodyPart build() {
            if (this.headers.toMap().size() == 0 && this.name != null) {
                this.headers = WriteableBodyPartHeaders.builder().name(this.name).filename(this.fileName).build();
            }
            return new WriteableBodyPart(this.content, this.headers);
        }
    }
}

