/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.media.multipart;

import io.helidon.media.multipart.VirtualBuffer;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

final class MimeParser {
    private static final Logger LOGGER = Logger.getLogger(MimeParser.class.getName());
    private static final Charset HEADER_ENCODING = StandardCharsets.ISO_8859_1;
    private static final StartMessageEvent START_MESSAGE_EVENT = new StartMessageEvent();
    private static final StartPartEvent START_PART_EVENT = new StartPartEvent();
    private static final EndHeadersEvent END_HEADERS_EVENT = new EndHeadersEvent();
    private static final EndPartEvent END_PART_EVENT = new EndPartEvent();
    private static final EndMessageEvent END_MESSAGE_EVENT = new EndMessageEvent();
    private STATE state = STATE.START_MESSAGE;
    private STATE resumeState = null;
    private final byte[] bndbytes;
    private final int bl;
    private final int[] bcs = new int[128];
    private final int[] gss;
    private boolean done = false;
    private boolean bol;
    private final VirtualBuffer buf;
    private int position;
    private int bndStart;
    private boolean closed;

    MimeParser(String boundary) {
        this.bndbytes = MimeParser.getBytes("--" + boundary);
        this.bl = this.bndbytes.length;
        this.gss = new int[this.bl];
        this.buf = new VirtualBuffer();
        this.compileBoundaryPattern();
    }

    int offer(ByteBuffer data) throws ParsingException {
        int id;
        if (this.closed) {
            throw new ParsingException("Parser is closed");
        }
        switch (this.state) {
            case START_MESSAGE: {
                id = this.buf.offer(data, 0);
                break;
            }
            case DATA_REQUIRED: {
                this.state = this.resumeState;
                this.resumeState = null;
                id = this.buf.offer(data, this.position);
                this.position = 0;
                break;
            }
            default: {
                throw new ParsingException("Invalid state: " + this.state);
            }
        }
        return id;
    }

    void close() throws ParsingException {
        this.cleanup();
        switch (this.state) {
            case START_MESSAGE: 
            case END_MESSAGE: {
                break;
            }
            case DATA_REQUIRED: {
                switch (this.resumeState) {
                    case SKIP_PREAMBLE: {
                        throw new ParsingException("Missing start boundary");
                    }
                    case BODY: {
                        throw new ParsingException("No closing MIME boundary");
                    }
                    case HEADERS: {
                        throw new ParsingException("No blank line found");
                    }
                }
                break;
            }
            default: {
                throw new ParsingException("Invalid state: " + this.state);
            }
        }
    }

    void cleanup() {
        this.closed = true;
        this.buf.clear();
    }

    Iterator<ParserEvent> parseIterator() {
        return new Iterator<ParserEvent>(){
            private ParserEvent nextEvent;
            private boolean done;

            @Override
            public ParserEvent next() {
                if (!this.hasNext()) {
                    throw new IllegalStateException("Read past end of stream");
                }
                ParserEvent ne = this.nextEvent;
                this.nextEvent = null;
                this.done = ne == END_MESSAGE_EVENT;
                return ne;
            }

            @Override
            public boolean hasNext() {
                if (this.nextEvent != null) {
                    return true;
                }
                try {
                    block13: while (true) {
                        switch (MimeParser.this.state) {
                            case START_MESSAGE: {
                                if (LOGGER.isLoggable(Level.FINER)) {
                                    LOGGER.log(Level.FINER, "state={0}", (Object)STATE.START_MESSAGE);
                                }
                                MimeParser.this.state = STATE.SKIP_PREAMBLE;
                                this.nextEvent = START_MESSAGE_EVENT;
                                return true;
                            }
                            case SKIP_PREAMBLE: {
                                if (LOGGER.isLoggable(Level.FINER)) {
                                    LOGGER.log(Level.FINER, "state={0}", (Object)STATE.SKIP_PREAMBLE);
                                }
                                MimeParser.this.skipPreamble();
                                if (MimeParser.this.bndStart == -1) {
                                    if (LOGGER.isLoggable(Level.FINER)) {
                                        LOGGER.log(Level.FINER, "state={0}", (Object)STATE.DATA_REQUIRED);
                                    }
                                    MimeParser.this.state = STATE.DATA_REQUIRED;
                                    MimeParser.this.resumeState = STATE.SKIP_PREAMBLE;
                                    return false;
                                }
                                if (LOGGER.isLoggable(Level.FINE)) {
                                    LOGGER.log(Level.FINE, "Skipped the preamble. position={0}", MimeParser.this.position);
                                }
                                MimeParser.this.state = STATE.START_PART;
                                continue block13;
                            }
                            case START_PART: {
                                if (LOGGER.isLoggable(Level.FINER)) {
                                    LOGGER.log(Level.FINER, "state={0}", (Object)STATE.START_PART);
                                }
                                MimeParser.this.state = STATE.HEADERS;
                                this.nextEvent = START_PART_EVENT;
                                return true;
                            }
                            case HEADERS: {
                                String headerLine;
                                if (LOGGER.isLoggable(Level.FINER)) {
                                    LOGGER.log(Level.FINER, "state={0}", (Object)STATE.HEADERS);
                                }
                                if ((headerLine = MimeParser.this.readHeaderLine()) == null) {
                                    if (LOGGER.isLoggable(Level.FINER)) {
                                        LOGGER.log(Level.FINER, "state={0}", (Object)STATE.DATA_REQUIRED);
                                    }
                                    MimeParser.this.state = STATE.DATA_REQUIRED;
                                    MimeParser.this.resumeState = STATE.HEADERS;
                                    return false;
                                }
                                if (!headerLine.isEmpty()) {
                                    Hdr header = new Hdr(headerLine);
                                    this.nextEvent = new HeaderEvent(header.name(), header.value());
                                    return true;
                                }
                                MimeParser.this.state = STATE.BODY;
                                MimeParser.this.bol = true;
                                this.nextEvent = END_HEADERS_EVENT;
                                return true;
                            }
                            case BODY: {
                                if (LOGGER.isLoggable(Level.FINER)) {
                                    LOGGER.log(Level.FINER, "state={0}", (Object)STATE.BODY);
                                }
                                List<VirtualBuffer.BufferEntry> bodyContent = MimeParser.this.readBody();
                                if (MimeParser.this.bndStart == -1 || bodyContent.isEmpty()) {
                                    if (LOGGER.isLoggable(Level.FINER)) {
                                        LOGGER.log(Level.FINER, "state={0}", (Object)STATE.DATA_REQUIRED);
                                    }
                                    MimeParser.this.state = STATE.DATA_REQUIRED;
                                    MimeParser.this.resumeState = STATE.BODY;
                                    if (bodyContent.isEmpty()) {
                                        return false;
                                    }
                                } else {
                                    MimeParser.this.bol = false;
                                }
                                this.nextEvent = new BodyEvent(bodyContent);
                                return true;
                            }
                            case END_PART: {
                                if (LOGGER.isLoggable(Level.FINER)) {
                                    LOGGER.log(Level.FINER, "state={0}", (Object)STATE.END_PART);
                                }
                                MimeParser.this.state = MimeParser.this.done ? STATE.END_MESSAGE : STATE.START_PART;
                                this.nextEvent = END_PART_EVENT;
                                return true;
                            }
                            case END_MESSAGE: {
                                if (LOGGER.isLoggable(Level.FINER)) {
                                    LOGGER.log(Level.FINER, "state={0}", (Object)STATE.END_MESSAGE);
                                }
                                if (this.done) {
                                    return false;
                                }
                                this.nextEvent = END_MESSAGE_EVENT;
                                return true;
                            }
                            case DATA_REQUIRED: {
                                return false;
                            }
                        }
                    }
                }
                catch (ParsingException ex) {
                    throw ex;
                }
                catch (Throwable ex) {
                    throw new ParsingException(ex);
                }
            }
        };
    }

    private List<VirtualBuffer.BufferEntry> readBody() {
        int bodyBegin;
        this.bndStart = this.match();
        int bufLen = this.buf.length();
        if (this.bndStart == -1) {
            if (this.position + this.bl + 1 < bufLen) {
                int bodyBegin2 = this.position;
                this.position = bufLen - (this.bl + 1);
                return this.buf.slice(bodyBegin2, this.position);
            }
            return Collections.emptyList();
        }
        int bodyEnd = this.bndStart;
        if (!this.bol || this.bndStart != this.position) {
            if (this.bndStart > this.position && (this.buf.getByte(this.bndStart - 1) == 10 || this.buf.getByte(this.bndStart - 1) == 13)) {
                --bodyEnd;
                if (this.buf.getByte(this.bndStart - 1) == 10 && this.bndStart > 1 && this.buf.getByte(this.bndStart - 2) == 13) {
                    --bodyEnd;
                }
            } else {
                int bodyBegin3 = this.position;
                this.position = bodyEnd + 1;
                return this.buf.slice(bodyBegin3, this.position);
            }
        }
        if (this.bndStart + this.bl + 1 < bufLen && this.buf.getByte(this.bndStart + this.bl) == 45 && this.buf.getByte(this.bndStart + this.bl + 1) == 45) {
            this.state = STATE.END_PART;
            this.done = true;
            int bodyBegin4 = this.position;
            this.position = this.bndStart + this.bl + 2;
            return this.buf.slice(bodyBegin4, bodyEnd);
        }
        int lwsp = 0;
        for (int i = this.bndStart + this.bl; i < bufLen && (this.buf.getByte(i) == 32 || this.buf.getByte(i) == 9); ++i) {
            ++lwsp;
        }
        if (this.bndStart + this.bl + lwsp < bufLen && this.buf.getByte(this.bndStart + this.bl + lwsp) == 10) {
            this.state = STATE.END_PART;
            bodyBegin = this.position;
            this.position = this.bndStart + this.bl + lwsp + 1;
            return this.buf.slice(bodyBegin, bodyEnd);
        }
        if (this.bndStart + this.bl + lwsp + 1 < bufLen && this.buf.getByte(this.bndStart + this.bl + lwsp) == 13 && this.buf.getByte(this.bndStart + this.bl + lwsp + 1) == 10) {
            this.state = STATE.END_PART;
            bodyBegin = this.position;
            this.position = this.bndStart + this.bl + lwsp + 2;
            return this.buf.slice(bodyBegin, bodyEnd);
        }
        if (this.bndStart + this.bl + lwsp + 1 < bufLen) {
            bodyBegin = this.position;
            this.position = bodyEnd + 1;
            return this.buf.slice(bodyBegin, bodyEnd + 1);
        }
        bodyBegin = this.position;
        this.position = this.bndStart;
        return this.buf.slice(bodyBegin, bodyEnd);
    }

    private void skipPreamble() {
        this.bndStart = this.match();
        if (this.bndStart == -1) {
            return;
        }
        int bufLen = this.buf.length();
        int lwsp = 0;
        for (int i = this.bndStart + this.bl; i < bufLen && (this.buf.getByte(i) == 32 || this.buf.getByte(i) == 9); ++i) {
            ++lwsp;
        }
        if (this.bndStart + this.bl + lwsp < bufLen && (this.buf.getByte(this.bndStart + this.bl + lwsp) == 10 || this.buf.getByte(this.bndStart + this.bl + lwsp) == 13)) {
            if (this.buf.getByte(this.bndStart + this.bl + lwsp) == 10) {
                this.position = this.bndStart + this.bl + lwsp + 1;
                return;
            }
            if (this.bndStart + this.bl + lwsp + 1 < bufLen && this.buf.getByte(this.bndStart + this.bl + lwsp + 1) == 10) {
                this.position = this.bndStart + this.bl + lwsp + 2;
                return;
            }
        }
        this.position = this.bndStart + 1;
    }

    private String readHeaderLine() {
        int bufLen = this.buf.length();
        if (this.position >= bufLen - 1) {
            return null;
        }
        int offset = this.position;
        int hdrLen = 0;
        int lwsp = 0;
        while (offset + hdrLen < bufLen) {
            if (this.buf.getByte(offset + hdrLen) == 10) {
                ++lwsp;
                break;
            }
            if (offset + hdrLen + 1 >= bufLen) {
                return null;
            }
            if (this.buf.getByte(offset + hdrLen) == 13 && this.buf.getByte(offset + hdrLen + 1) == 10) {
                lwsp += 2;
                break;
            }
            ++hdrLen;
        }
        this.position = offset + hdrLen + lwsp;
        if (hdrLen == 0) {
            return "";
        }
        return new String(this.buf.getBytes(offset, hdrLen), HEADER_ENCODING);
    }

    private void compileBoundaryPattern() {
        int i;
        for (i = 0; i < this.bndbytes.length; ++i) {
            this.bcs[this.bndbytes[i] & 0x7F] = i + 1;
        }
        block1: for (i = this.bndbytes.length; i > 0; --i) {
            int j;
            for (j = this.bndbytes.length - 1; j >= i; --j) {
                if (this.bndbytes[j] != this.bndbytes[j - i]) continue block1;
                this.gss[j - 1] = i;
            }
            while (j > 0) {
                this.gss[--j] = i;
            }
        }
        this.gss[this.bndbytes.length - 1] = 1;
    }

    private int match() {
        byte ch;
        int j;
        int last = this.buf.length() - this.bndbytes.length;
        block0: for (int off = this.position; off <= last; off += Math.max(j + 1 - this.bcs[ch & 0x7F], this.gss[j])) {
            for (j = this.bndbytes.length - 1; j >= 0; --j) {
                ch = this.buf.getByte(off + j);
                if (ch == this.bndbytes[j]) continue;
                continue block0;
            }
            return off;
        }
        return -1;
    }

    private static byte[] getBytes(String str) {
        char[] chars = str.toCharArray();
        int size = chars.length;
        byte[] bytes = new byte[size];
        int i = 0;
        while (i < size) {
            bytes[i] = (byte)chars[i++];
        }
        return bytes;
    }

    private static final class Hdr {
        private final String name;
        private final String line;

        Hdr(String l) {
            int i = l.indexOf(58);
            this.name = i < 0 ? l.trim() : l.substring(0, i).trim();
            this.line = l;
        }

        String name() {
            return this.name;
        }

        String value() {
            char c;
            int j;
            int i = this.line.indexOf(58);
            if (i < 0) {
                return this.line;
            }
            for (j = i + 1; j < this.line.length() && ((c = this.line.charAt(j)) == ' ' || c == '\t'); ++j) {
            }
            return this.line.substring(j);
        }
    }

    private static enum STATE {
        START_MESSAGE,
        SKIP_PREAMBLE,
        START_PART,
        HEADERS,
        BODY,
        END_PART,
        END_MESSAGE,
        DATA_REQUIRED;

    }

    static final class ParsingException
    extends RuntimeException {
        private ParsingException(String message) {
            super(message);
        }

        private ParsingException(Throwable cause) {
            super(cause);
        }
    }

    static final class EndMessageEvent
    extends ParserEvent {
        private EndMessageEvent() {
        }

        @Override
        EventType type() {
            return EventType.END_MESSAGE;
        }
    }

    static final class EndPartEvent
    extends ParserEvent {
        private EndPartEvent() {
        }

        @Override
        EventType type() {
            return EventType.END_PART;
        }
    }

    static final class BodyEvent
    extends ParserEvent {
        private final List<VirtualBuffer.BufferEntry> buffers;

        BodyEvent(List<VirtualBuffer.BufferEntry> data) {
            this.buffers = data;
        }

        List<VirtualBuffer.BufferEntry> body() {
            return this.buffers;
        }

        @Override
        EventType type() {
            return EventType.BODY;
        }
    }

    static final class EndHeadersEvent
    extends ParserEvent {
        private EndHeadersEvent() {
        }

        @Override
        EventType type() {
            return EventType.END_HEADERS;
        }
    }

    static final class HeaderEvent
    extends ParserEvent {
        private final String name;
        private final String value;

        private HeaderEvent(String name, String value) {
            this.name = name;
            this.value = value;
        }

        String name() {
            return this.name;
        }

        String value() {
            return this.value;
        }

        @Override
        EventType type() {
            return EventType.HEADER;
        }
    }

    static final class StartPartEvent
    extends ParserEvent {
        private StartPartEvent() {
        }

        @Override
        EventType type() {
            return EventType.START_PART;
        }
    }

    static final class StartMessageEvent
    extends ParserEvent {
        private StartMessageEvent() {
        }

        @Override
        EventType type() {
            return EventType.START_MESSAGE;
        }
    }

    static abstract class ParserEvent {
        ParserEvent() {
        }

        abstract EventType type();

        HeaderEvent asHeaderEvent() {
            return (HeaderEvent)this;
        }

        BodyEvent asBodyEvent() {
            return (BodyEvent)this;
        }
    }

    static enum EventType {
        START_MESSAGE,
        START_PART,
        HEADER,
        END_HEADERS,
        BODY,
        END_PART,
        END_MESSAGE;

    }
}

