/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.media.multipart;

import io.helidon.media.multipart.BodyPart;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public interface MultiPart<T extends BodyPart> {
    public List<T> bodyParts();

    default public Optional<T> field(String name) {
        if (name == null) {
            return Optional.empty();
        }
        for (BodyPart part : this.bodyParts()) {
            String partName = part.name();
            if (partName == null || !name.equals(partName)) continue;
            return Optional.of(part);
        }
        return Optional.empty();
    }

    default public List<T> fields(String name) {
        if (name == null) {
            return Collections.emptyList();
        }
        ArrayList<BodyPart> result = new ArrayList<BodyPart>();
        for (BodyPart part : this.bodyParts()) {
            String partName = part.name();
            if (partName == null || !partName.equals(name)) continue;
            result.add(part);
        }
        return result;
    }

    default public Map<String, List<T>> fields() {
        HashMap<String, List<T>> results = new HashMap<String, List<T>>();
        for (BodyPart part : this.bodyParts()) {
            String name = part.name();
            if (name == null) continue;
            ArrayList<BodyPart> result = (ArrayList<BodyPart>)results.get(name);
            if (result == null) {
                result = new ArrayList<BodyPart>();
                results.put(name, result);
            }
            result.add(part);
        }
        return results;
    }
}

