/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.media.multipart;

import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.LinkedList;

final class VirtualBuffer {
    private static final int DEFAULT_CAPACITY = 8;
    private ByteBuffer[] buffers;
    private int[] bufferIds;
    private int count;
    private int startIndex;
    private int endIndex;
    private int voffset;
    private int vlength;
    private int nextId;

    private VirtualBuffer(int initialCapacity) {
        this.bufferIds = new int[initialCapacity];
        this.buffers = new ByteBuffer[initialCapacity];
        this.voffset = 0;
        this.vlength = 0;
        this.nextId = 0;
        this.count = 0;
        this.startIndex = 0;
        this.endIndex = 0;
    }

    VirtualBuffer() {
        this(8);
    }

    int length() {
        return this.vlength;
    }

    int buffersCount() {
        return this.count;
    }

    void clear() {
        Arrays.fill(this.buffers, null);
        Arrays.fill(this.bufferIds, 0);
        this.voffset = 0;
        this.vlength = 0;
        this.nextId = 0;
        this.count = 0;
        this.startIndex = 0;
        this.endIndex = 0;
    }

    int offer(ByteBuffer buffer, int newOffset) {
        if (newOffset < 0) {
            throw new IllegalArgumentException("Negative offset: " + newOffset);
        }
        if (this.buffers.length == this.count) {
            this.doubleCapacity();
        }
        this.buffers[this.endIndex] = buffer.asReadOnlyBuffer();
        this.bufferIds[this.endIndex] = ++this.nextId;
        if (this.nextId == Integer.MAX_VALUE) {
            this.nextId = 0;
        }
        ++this.count;
        this.endIndex = this.nextBufferIndex(this.endIndex);
        this.vlength = this.vlength + buffer.limit() - newOffset;
        int pos = 0;
        int off = this.voffset + newOffset;
        boolean found = false;
        int i = this.startIndex;
        while (this.isBufferIndex(i) && pos <= off) {
            int nextPosition = pos + this.buffers[i].limit();
            if (nextPosition >= off) {
                this.voffset = off - pos;
                found = true;
                break;
            }
            pos = nextPosition;
            this.buffers[i] = null;
            this.bufferIds[i] = 0;
            --this.count;
            this.startIndex = this.nextBufferIndex(this.startIndex);
            i = this.nextBufferIndex(i);
        }
        if (!found) {
            throw new IllegalStateException("Unable to find new absolute position for offset: " + newOffset);
        }
        return this.nextId;
    }

    byte getByte(int index) {
        if (index < 0 || index >= this.vlength) {
            throw new IndexOutOfBoundsException("Invalid index: " + index);
        }
        int pos = 0;
        int off = this.voffset + index;
        int i = this.startIndex;
        while (this.isBufferIndex(i)) {
            ByteBuffer buffer = this.buffers[i];
            int nextPos = pos + buffer.limit();
            if (nextPos > off) {
                return buffer.get(off - pos);
            }
            pos = nextPos;
            i = this.nextBufferIndex(i);
        }
        throw new IllegalStateException("End of virtual buffer");
    }

    byte[] getBytes(int begin, int len) {
        this.checkBounds(begin, begin + len - 1);
        byte[] dst = new byte[len];
        int pos = 0;
        int nbytes = 0;
        int off = this.voffset + begin;
        int i = this.startIndex;
        while (this.isBufferIndex(i)) {
            int index;
            ByteBuffer buffer = this.buffers[i];
            int nextPos = pos + buffer.limit();
            while (nbytes < len && (index = off + nbytes) < nextPos) {
                dst[nbytes] = buffer.get(index - pos);
                ++nbytes;
            }
            pos = nextPos;
            i = this.nextBufferIndex(i);
        }
        if (nbytes < len - 1) {
            throw new BufferUnderflowException();
        }
        return dst;
    }

    LinkedList<BufferEntry> slice(int begin, int end) {
        this.checkBounds(begin, end);
        LinkedList<BufferEntry> slices = new LinkedList<BufferEntry>();
        int len = end - begin;
        int pos = 0;
        int nslices = 0;
        int off = this.voffset + begin;
        int i = this.startIndex;
        while (this.isBufferIndex(i)) {
            ByteBuffer buffer = this.buffers[i];
            int limit = buffer.limit();
            int nextPos = pos + limit;
            if (off < nextPos) {
                ByteBuffer slice = buffer.asReadOnlyBuffer();
                int index = off < pos ? 0 : off - pos;
                slice.position(index);
                slices.add(new BufferEntry(slice, this.bufferIds[i]));
                if (off + len <= nextPos) {
                    slice.limit(index + len - nslices);
                    return slices;
                }
                nslices += limit - index;
            }
            pos = nextPos;
            i = this.nextBufferIndex(i);
        }
        throw new BufferUnderflowException();
    }

    private void doubleCapacity() {
        ByteBuffer[] newBuffers = new ByteBuffer[this.buffers.length * 2];
        int[] newIds = new int[this.buffers.length * 2];
        int count1 = this.count - (this.startIndex + 1);
        int count2 = this.count - count1;
        System.arraycopy(this.buffers, this.startIndex, newBuffers, 0, count1);
        System.arraycopy(this.buffers, 0, newBuffers, count1, count2);
        System.arraycopy(this.bufferIds, this.startIndex, newIds, 0, count1);
        System.arraycopy(this.bufferIds, 0, newIds, count1, count2);
        this.buffers = newBuffers;
        this.bufferIds = newIds;
        this.startIndex = 0;
        this.endIndex = this.count - 1;
    }

    private boolean isBufferIndex(int index) {
        if (this.endIndex > this.startIndex) {
            return index < this.endIndex && index >= this.startIndex;
        }
        return index < this.endIndex || index >= this.startIndex;
    }

    private int nextBufferIndex(int index) {
        if (index + 1 == this.buffers.length) {
            return 0;
        }
        return index + 1;
    }

    private void checkBounds(int begin, int end) {
        if (begin < 0 || begin >= this.vlength || end <= 0 || end > this.vlength || begin > end) {
            throw new IndexOutOfBoundsException("Invalid range, begin=" + begin + ", end=" + end);
        }
    }

    static final class BufferEntry {
        private final ByteBuffer buffer;
        private final int id;

        private BufferEntry(ByteBuffer buffer, int id) {
            this.buffer = buffer;
            this.id = id;
        }

        ByteBuffer buffer() {
            return this.buffer;
        }

        int id() {
            return this.id;
        }
    }
}

