/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.media.multipart;

import io.helidon.media.multipart.MultiPart;
import io.helidon.media.multipart.WriteableBodyPart;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public final class WriteableMultiPart
implements MultiPart<WriteableBodyPart> {
    private final List<WriteableBodyPart> parts;

    private WriteableMultiPart(List<WriteableBodyPart> parts) {
        this.parts = parts;
    }

    @Override
    public List<WriteableBodyPart> bodyParts() {
        return this.parts;
    }

    public static WriteableMultiPart create(WriteableBodyPart ... entities) {
        Builder builder = WriteableMultiPart.builder();
        for (WriteableBodyPart entity : entities) {
            builder.bodyPart(WriteableBodyPart.create(entity));
        }
        return builder.build();
    }

    public static WriteableMultiPart create(Collection<WriteableBodyPart> entities) {
        Builder builder = WriteableMultiPart.builder();
        for (WriteableBodyPart entity : entities) {
            builder.bodyPart(WriteableBodyPart.create(entity));
        }
        return builder.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    implements io.helidon.common.Builder<WriteableMultiPart> {
        private final ArrayList<WriteableBodyPart> bodyParts = new ArrayList();

        private Builder() {
        }

        public Builder bodyPart(WriteableBodyPart bodyPart) {
            this.bodyParts.add(bodyPart);
            return this;
        }

        public Builder bodyParts(Collection<WriteableBodyPart> bodyParts) {
            this.bodyParts.addAll(bodyParts);
            return this;
        }

        public WriteableMultiPart build() {
            return new WriteableMultiPart(this.bodyParts);
        }
    }
}

