/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.media.multipart;

import io.helidon.common.http.DataChunk;
import io.helidon.common.http.ReadOnlyParameters;
import io.helidon.common.reactive.BufferedEmittingPublisher;
import io.helidon.common.reactive.SubscriptionHelper;
import io.helidon.media.common.MessageBodyReadableContent;
import io.helidon.media.common.MessageBodyReaderContext;
import io.helidon.media.multipart.BodyPartChunk;
import io.helidon.media.multipart.MimeParser;
import io.helidon.media.multipart.ReadableBodyPart;
import io.helidon.media.multipart.ReadableBodyPartHeaders;
import io.helidon.media.multipart.VirtualBuffer;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Flow;

public class MultiPartDecoder
implements Flow.Processor<DataChunk, ReadableBodyPart> {
    private Flow.Subscription upstream;
    private Flow.Subscriber<? super ReadableBodyPart> downstream;
    private BufferedEmittingPublisher<ReadableBodyPart> emitter;
    private ReadableBodyPart.Builder bodyPartBuilder;
    private ReadableBodyPartHeaders.Builder bodyPartHeaderBuilder;
    private BufferedEmittingPublisher<DataChunk> bodyPartPublisher;
    private final CompletableFuture<BufferedEmittingPublisher<ReadableBodyPart>> initFuture;
    private final LinkedList<ReadableBodyPart> bodyParts;
    private final HashMap<Integer, DataChunk> chunksByIds;
    private final MimeParser parser;
    private final ParserEventProcessor parserEventProcessor;
    private final MessageBodyReaderContext context;

    MultiPartDecoder(String boundary, MessageBodyReaderContext context) {
        Objects.requireNonNull(boundary, "boundary cannot be null!");
        Objects.requireNonNull(context, "context cannot be null!");
        this.context = context;
        this.parserEventProcessor = new ParserEventProcessor();
        this.parser = new MimeParser(boundary, this.parserEventProcessor);
        this.initFuture = new CompletableFuture();
        this.bodyParts = new LinkedList();
        this.chunksByIds = new HashMap();
    }

    public static MultiPartDecoder create(String boundary, MessageBodyReaderContext context) {
        return new MultiPartDecoder(boundary, context);
    }

    @Override
    public void subscribe(Flow.Subscriber<? super ReadableBodyPart> subscriber) {
        Objects.requireNonNull(subscriber);
        if (this.emitter != null || this.downstream != null) {
            subscriber.onSubscribe((Flow.Subscription)SubscriptionHelper.CANCELED);
            subscriber.onError(new IllegalStateException("Only one Subscriber allowed"));
            return;
        }
        this.downstream = subscriber;
        this.deferredInit();
    }

    @Override
    public void onSubscribe(Flow.Subscription subscription) {
        SubscriptionHelper.validate((Flow.Subscription)this.upstream, (Flow.Subscription)subscription);
        this.upstream = subscription;
        this.deferredInit();
    }

    @Override
    public void onNext(DataChunk chunk) {
        try {
            ByteBuffer[] byteBuffers = chunk.data();
            for (int i = 0; i < byteBuffers.length; ++i) {
                int id = this.parser.offer(byteBuffers[i]);
                if (i != byteBuffers.length - 1) continue;
                this.chunksByIds.put(id, chunk);
            }
            this.parser.parse();
        }
        catch (MimeParser.ParsingException ex) {
            this.emitter.fail((Throwable)ex);
            chunk.release();
            this.releaseChunks();
        }
        while (!this.bodyParts.isEmpty()) {
            if (this.emitter.isCancelled()) {
                return;
            }
            this.emitter.emit((Object)this.bodyParts.poll());
        }
        if (this.parserEventProcessor.isCompleted()) {
            this.emitter.complete();
            this.emitter.clearBuffer(this::drainPart);
            this.releaseChunks();
        }
        if (this.upstream != SubscriptionHelper.CANCELED && this.emitter.hasRequests() && this.parserEventProcessor.isDataRequired() && (!this.parserEventProcessor.isContentDataRequired() || this.bodyPartPublisher.hasRequests())) {
            this.upstream.request(1L);
        }
    }

    @Override
    public void onError(Throwable throwable) {
        Objects.requireNonNull(throwable);
        this.initFuture.whenComplete((e, t) -> e.fail(throwable));
    }

    @Override
    public void onComplete() {
        this.initFuture.whenComplete((e, t) -> {
            if (this.upstream != SubscriptionHelper.CANCELED) {
                this.upstream = SubscriptionHelper.CANCELED;
                try {
                    this.parser.close();
                }
                catch (MimeParser.ParsingException ex) {
                    this.emitter.fail((Throwable)ex);
                    this.releaseChunks();
                }
            }
        });
    }

    private void deferredInit() {
        if (this.upstream != null && this.downstream != null) {
            this.emitter = BufferedEmittingPublisher.create();
            this.emitter.onRequest(this::onPartRequest);
            this.emitter.onEmit(this::drainPart);
            this.emitter.subscribe(this.downstream);
            this.initFuture.complete(this.emitter);
            this.downstream = null;
        }
    }

    private void onPartRequest(long requested, long total) {
        if (!this.parserEventProcessor.isStarted() || this.parserEventProcessor.isDataRequired()) {
            this.upstream.request(1L);
        }
    }

    private void onPartCancel() {
        this.emitter.clearBuffer(this::drainPart);
        this.releaseChunks();
    }

    private void releaseChunks() {
        Iterator<DataChunk> it = this.chunksByIds.values().iterator();
        while (it.hasNext()) {
            DataChunk next = it.next();
            next.release();
            it.remove();
        }
    }

    private void drainPart(ReadableBodyPart part) {
        part.content().subscribe((Flow.Subscriber)new Flow.Subscriber<DataChunk>(){

            @Override
            public void onSubscribe(Flow.Subscription subscription) {
                subscription.request(Long.MAX_VALUE);
            }

            @Override
            public void onNext(DataChunk item) {
                item.release();
            }

            @Override
            public void onError(Throwable throwable) {
            }

            @Override
            public void onComplete() {
            }
        });
    }

    private ReadableBodyPart createPart() {
        ReadableBodyPartHeaders headers = this.bodyPartHeaderBuilder.build();
        MessageBodyReaderContext partContext = MessageBodyReaderContext.create((MessageBodyReaderContext)this.context, null, (ReadOnlyParameters)headers, Optional.of(headers.contentType()));
        MessageBodyReadableContent partContent = MessageBodyReadableContent.create(this.bodyPartPublisher, (MessageBodyReaderContext)partContext);
        return this.bodyPartBuilder.headers(headers).content(partContent).build();
    }

    private BodyPartChunk createPartChunk(VirtualBuffer.BufferEntry entry) {
        boolean release;
        ByteBuffer data = entry.buffer();
        int id = entry.id();
        DataChunk chunk = this.chunksByIds.get(id);
        if (chunk == null) {
            throw new IllegalStateException("Parent chunk not found, id=" + id);
        }
        ByteBuffer[] originalBuffers = chunk.data();
        boolean bl = release = data.limit() == originalBuffers[originalBuffers.length - 1].limit();
        if (release) {
            this.chunksByIds.remove(id);
        }
        return new BodyPartChunk(data, (DataChunk)(release ? chunk : null));
    }

    private final class ParserEventProcessor
    implements MimeParser.EventProcessor {
        private MimeParser.ParserEvent lastEvent = null;

        private ParserEventProcessor() {
        }

        @Override
        public void process(MimeParser.ParserEvent event) {
            MimeParser.EventType eventType = event.type();
            switch (eventType) {
                case START_PART: {
                    MultiPartDecoder.this.bodyPartPublisher = BufferedEmittingPublisher.create();
                    MultiPartDecoder.this.bodyPartHeaderBuilder = ReadableBodyPartHeaders.builder();
                    MultiPartDecoder.this.bodyPartBuilder = ReadableBodyPart.builder();
                    break;
                }
                case HEADER: {
                    MimeParser.HeaderEvent headerEvent = event.asHeaderEvent();
                    MultiPartDecoder.this.bodyPartHeaderBuilder.header(headerEvent.name(), headerEvent.value());
                    break;
                }
                case END_HEADERS: {
                    MultiPartDecoder.this.bodyParts.add(MultiPartDecoder.this.createPart());
                    break;
                }
                case CONTENT: {
                    MultiPartDecoder.this.bodyPartPublisher.emit((Object)MultiPartDecoder.this.createPartChunk(event.asContentEvent().content()));
                    break;
                }
                case END_PART: {
                    MultiPartDecoder.this.bodyPartPublisher.complete();
                    MultiPartDecoder.this.bodyPartPublisher = null;
                    MultiPartDecoder.this.bodyPartHeaderBuilder = null;
                    MultiPartDecoder.this.bodyPartBuilder = null;
                    break;
                }
            }
            this.lastEvent = event;
        }

        boolean isStarted() {
            return this.lastEvent != null;
        }

        boolean isCompleted() {
            return this.lastEvent.type() == MimeParser.EventType.END_MESSAGE;
        }

        boolean isDataRequired() {
            return this.lastEvent.type() == MimeParser.EventType.DATA_REQUIRED;
        }

        boolean isContentDataRequired() {
            return this.isDataRequired() && this.lastEvent.asDataRequiredEvent().isContent();
        }
    }
}

