/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.media.multipart;

import io.helidon.common.http.HashParameters;
import io.helidon.common.http.MediaType;
import io.helidon.media.multipart.BodyPartHeaders;
import io.helidon.media.multipart.ContentDisposition;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public final class WriteableBodyPartHeaders
extends HashParameters
implements BodyPartHeaders {
    private WriteableBodyPartHeaders(Map<String, List<String>> params) {
        super(params);
    }

    @Override
    public MediaType contentType() {
        return this.first("Content-Type").map(MediaType::parse).orElseGet(this::defaultContentType);
    }

    public void contentType(MediaType contentType) {
        if (contentType == null) {
            this.remove("Content-Type");
        } else {
            this.put("Content-Type", new String[]{contentType.toString()});
        }
    }

    @Override
    public ContentDisposition contentDisposition() {
        return this.first("Content-Disposition").map(ContentDisposition::parse).orElse(ContentDisposition.EMPTY);
    }

    public void contentDisposition(ContentDisposition contentDisposition) {
        if (contentDisposition != null) {
            this.put("Content-Disposition", new String[]{contentDisposition.toString()});
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public static WriteableBodyPartHeaders create() {
        return new WriteableBodyPartHeaders(null);
    }

    public static final class Builder
    implements io.helidon.common.Builder<WriteableBodyPartHeaders> {
        private final Map<String, List<String>> headers = new TreeMap<String, List<String>>(String.CASE_INSENSITIVE_ORDER);

        private Builder() {
        }

        public Builder header(String name, String value) {
            List<String> values = this.headers.get(name);
            if (values == null) {
                values = new ArrayList<String>();
                this.headers.put(name, values);
            }
            values.add(value);
            return this;
        }

        public Builder contentType(MediaType contentType) {
            return this.header("Content-Type", contentType.toString());
        }

        public Builder contentDisposition(ContentDisposition contentDisp) {
            return this.header("Content-Disposition", contentDisp.toString());
        }

        public WriteableBodyPartHeaders build() {
            return new WriteableBodyPartHeaders(this.headers);
        }
    }
}

