/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.media.multipart;

import io.helidon.common.http.DataChunk;
import io.helidon.common.reactive.BufferedEmittingPublisher;
import io.helidon.common.reactive.Multi;
import io.helidon.common.reactive.Single;
import io.helidon.common.reactive.SubscriptionHelper;
import io.helidon.media.common.MessageBodyWriterContext;
import io.helidon.media.multipart.WriteableBodyPart;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Flow;
import java.util.function.Function;

public class MultiPartEncoder
implements Flow.Processor<WriteableBodyPart, DataChunk> {
    private final MessageBodyWriterContext context;
    private final String boundary;
    private final CompletableFuture<BufferedEmittingPublisher<Flow.Publisher<DataChunk>>> initFuture;
    private BufferedEmittingPublisher<Flow.Publisher<DataChunk>> emitter;
    private Flow.Subscriber<? super DataChunk> downstream;
    private Flow.Subscription upstream;

    MultiPartEncoder(String boundary, MessageBodyWriterContext context) {
        Objects.requireNonNull(boundary, "boundary cannot be null!");
        Objects.requireNonNull(context, "context cannot be null!");
        this.context = context;
        this.boundary = boundary;
        this.initFuture = new CompletableFuture();
    }

    public static MultiPartEncoder create(String boundary, MessageBodyWriterContext context) {
        return new MultiPartEncoder(boundary, context);
    }

    @Override
    public void subscribe(Flow.Subscriber<? super DataChunk> subscriber) {
        Objects.requireNonNull(subscriber);
        if (this.emitter != null || this.downstream != null) {
            subscriber.onSubscribe((Flow.Subscription)SubscriptionHelper.CANCELED);
            subscriber.onError(new IllegalStateException("Only one Subscriber allowed"));
            return;
        }
        this.downstream = subscriber;
        this.deferredInit();
    }

    @Override
    public void onSubscribe(Flow.Subscription subscription) {
        SubscriptionHelper.validate((Flow.Subscription)this.upstream, (Flow.Subscription)subscription);
        this.upstream = subscription;
        this.deferredInit();
    }

    private void deferredInit() {
        if (this.upstream != null && this.downstream != null) {
            this.emitter = BufferedEmittingPublisher.create();
            this.emitter.onRequest((r, t) -> this.upstream.request((long)r));
            Multi.create(this.emitter).flatMap(Function.identity()).onCompleteResume((Object)DataChunk.create((byte[])("--" + this.boundary + "--").getBytes(StandardCharsets.UTF_8))).subscribe(this.downstream);
            this.initFuture.complete(this.emitter);
            this.downstream = null;
        }
    }

    @Override
    public void onNext(WriteableBodyPart bodyPart) {
        this.emitter.emit(this.createBodyPartPublisher(bodyPart));
    }

    @Override
    public void onError(Throwable throwable) {
        Objects.requireNonNull(throwable);
        this.initFuture.whenComplete((e, t) -> e.fail(throwable));
    }

    @Override
    public void onComplete() {
        this.initFuture.whenComplete((e, t) -> e.complete());
    }

    private Flow.Publisher<DataChunk> createBodyPartPublisher(WriteableBodyPart bodyPart) {
        StringBuilder sb = new StringBuilder("--").append(this.boundary).append("\r\n");
        Map headers = bodyPart.headers().toMap();
        for (Map.Entry headerEntry : headers.entrySet()) {
            String headerName = (String)headerEntry.getKey();
            for (String headerValue : (List)headerEntry.getValue()) {
                sb.append(headerName).append(":").append(headerValue).append("\r\n");
            }
        }
        sb.append("\r\n");
        return Multi.concat((Flow.Publisher)Multi.concat((Flow.Publisher)Single.just((Object)DataChunk.create((byte[])sb.toString().getBytes(StandardCharsets.UTF_8))), (Flow.Publisher)((Object)bodyPart.content().init(this.context))), (Flow.Publisher)Single.just((Object)DataChunk.create((byte[])"\n".getBytes(StandardCharsets.UTF_8))));
    }
}

