/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.media.jsonb;

import io.helidon.common.LazyValue;
import io.helidon.media.common.MediaSupport;
import io.helidon.media.common.MessageBodyReader;
import io.helidon.media.common.MessageBodyStreamWriter;
import io.helidon.media.common.MessageBodyWriter;
import io.helidon.media.jsonb.JsonbBodyReader;
import io.helidon.media.jsonb.JsonbBodyStreamWriter;
import io.helidon.media.jsonb.JsonbBodyWriter;
import io.helidon.media.jsonb.JsonbEsBodyStreamWriter;
import io.helidon.media.jsonb.JsonbNdBodyStreamWriter;
import jakarta.json.bind.Jsonb;
import jakarta.json.bind.JsonbBuilder;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public final class JsonbSupport
implements MediaSupport {
    private static final Jsonb JSON_B = JsonbBuilder.create();
    private static final LazyValue<JsonbSupport> DEFAULT = LazyValue.create(() -> new JsonbSupport(JSON_B));
    private final JsonbBodyReader reader;
    private final JsonbBodyWriter writer;
    private final JsonbBodyStreamWriter streamWriter;
    private final JsonbEsBodyStreamWriter esStreamWriter;
    private final JsonbNdBodyStreamWriter ndStreamWriter;

    private JsonbSupport(Jsonb jsonb) {
        this.reader = JsonbBodyReader.create(jsonb);
        this.writer = JsonbBodyWriter.create(jsonb);
        this.streamWriter = JsonbBodyStreamWriter.create(jsonb);
        this.esStreamWriter = JsonbEsBodyStreamWriter.create(jsonb);
        this.ndStreamWriter = JsonbNdBodyStreamWriter.create(jsonb);
    }

    public static JsonbSupport create() {
        return (JsonbSupport)DEFAULT.get();
    }

    public static JsonbSupport create(Jsonb jsonb) {
        Objects.requireNonNull(jsonb);
        return new JsonbSupport(jsonb);
    }

    public static MessageBodyReader<Object> reader() {
        return ((JsonbSupport)JsonbSupport.DEFAULT.get()).reader;
    }

    public static MessageBodyReader<Object> reader(Jsonb jsonb) {
        Objects.requireNonNull(jsonb);
        return JsonbBodyReader.create(jsonb);
    }

    public static MessageBodyWriter<Object> writer() {
        return ((JsonbSupport)JsonbSupport.DEFAULT.get()).writer;
    }

    public static MessageBodyWriter<Object> writer(Jsonb jsonb) {
        Objects.requireNonNull(jsonb);
        return JsonbBodyWriter.create(jsonb);
    }

    public static MessageBodyStreamWriter<Object> streamWriter() {
        return ((JsonbSupport)JsonbSupport.DEFAULT.get()).streamWriter;
    }

    public static MessageBodyStreamWriter<Object> streamWriter(Jsonb jsonb) {
        Objects.requireNonNull(jsonb);
        return JsonbBodyStreamWriter.create(jsonb);
    }

    public static MessageBodyStreamWriter<Object> eventStreamWriter() {
        return ((JsonbSupport)JsonbSupport.DEFAULT.get()).esStreamWriter;
    }

    public static MessageBodyStreamWriter<Object> eventStreamWriter(Jsonb jsonb) {
        Objects.requireNonNull(jsonb);
        return JsonbEsBodyStreamWriter.create(jsonb);
    }

    public static MessageBodyStreamWriter<Object> ndJsonStreamWriter() {
        return ((JsonbSupport)JsonbSupport.DEFAULT.get()).ndStreamWriter;
    }

    public static MessageBodyStreamWriter<Object> ndJsonStreamWriter(Jsonb jsonb) {
        Objects.requireNonNull(jsonb);
        return JsonbNdBodyStreamWriter.create(jsonb);
    }

    public MessageBodyReader<Object> readerInstance() {
        return this.reader;
    }

    public MessageBodyWriter<Object> writerInstance() {
        return this.writer;
    }

    public MessageBodyStreamWriter<Object> streamWriterInstance() {
        return this.streamWriter;
    }

    public MessageBodyStreamWriter<Object> eventStreamWriterInstance() {
        return this.esStreamWriter;
    }

    public MessageBodyStreamWriter<Object> ndJsonStreamWriterInstance() {
        return this.ndStreamWriter;
    }

    public Collection<MessageBodyReader<?>> readers() {
        return List.of(this.reader);
    }

    public Collection<MessageBodyWriter<?>> writers() {
        return List.of(this.writer);
    }

    public Collection<MessageBodyStreamWriter<?>> streamWriters() {
        return List.of(this.streamWriter, this.ndStreamWriter, this.esStreamWriter);
    }
}

