/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.media.jsonb;

import io.helidon.common.GenericType;
import io.helidon.common.http.DataChunk;
import io.helidon.common.http.MediaType;
import io.helidon.common.reactive.Multi;
import io.helidon.media.common.MessageBodyOperator;
import io.helidon.media.common.MessageBodyStreamWriter;
import io.helidon.media.common.MessageBodyWriterContext;
import io.helidon.media.jsonb.JsonbBodyWriter;
import jakarta.json.bind.Jsonb;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.concurrent.Flow;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;

class JsonbBodyStreamWriter
implements MessageBodyStreamWriter<Object> {
    private static final byte[] ARRAY_JSON_END_BYTES = "]".getBytes(StandardCharsets.UTF_8);
    private static final byte[] ARRAY_JSON_BEGIN_BYTES = "[".getBytes(StandardCharsets.UTF_8);
    private static final byte[] COMMA_BYTES = ",".getBytes(StandardCharsets.UTF_8);
    private final Jsonb jsonb;

    private JsonbBodyStreamWriter(Jsonb jsonb) {
        this.jsonb = Objects.requireNonNull(jsonb);
    }

    static JsonbBodyStreamWriter create(Jsonb jsonb) {
        return new JsonbBodyStreamWriter(jsonb);
    }

    public MessageBodyOperator.PredicateResult accept(GenericType<?> type, MessageBodyWriterContext context) {
        return !CharSequence.class.isAssignableFrom(type.rawType()) ? MessageBodyOperator.PredicateResult.COMPATIBLE : MessageBodyOperator.PredicateResult.NOT_SUPPORTED;
    }

    public Multi<DataChunk> write(Flow.Publisher<?> publisher, GenericType<?> type, MessageBodyWriterContext context) {
        MediaType contentType = context.findAccepted(MediaType.JSON_PREDICATE, MediaType.APPLICATION_JSON);
        context.contentType(contentType);
        AtomicBoolean first = new AtomicBoolean(true);
        JsonbBodyWriter.ObjectToChunks jsonToChunks = new JsonbBodyWriter.ObjectToChunks(this.jsonb, context.charset());
        return Multi.create(publisher).flatMap((Function)((Object)jsonToChunks)).flatMap(it -> {
            if (first.getAndSet(false)) {
                return Multi.just((Object[])new DataChunk[]{DataChunk.create((byte[])ARRAY_JSON_BEGIN_BYTES), it});
            }
            return Multi.just((Object[])new DataChunk[]{DataChunk.create((byte[])COMMA_BYTES), it});
        }).onCompleteResume((Object)DataChunk.create((byte[])ARRAY_JSON_END_BYTES));
    }
}

