/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.media.jsonb;

import io.helidon.common.GenericType;
import io.helidon.common.http.DataChunk;
import io.helidon.common.http.MediaType;
import io.helidon.common.reactive.Multi;
import io.helidon.common.reactive.Single;
import io.helidon.media.common.MessageBodyOperator;
import io.helidon.media.common.MessageBodyStreamWriter;
import io.helidon.media.common.MessageBodyWriterContext;
import jakarta.json.bind.Jsonb;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Flow;
import java.util.concurrent.atomic.AtomicBoolean;

class JsonbNdBodyStreamWriter
implements MessageBodyStreamWriter<Object> {
    private static final byte[] NL = "\n".getBytes(StandardCharsets.UTF_8);
    private final Jsonb jsonb;

    private JsonbNdBodyStreamWriter(Jsonb jsonb) {
        this.jsonb = Objects.requireNonNull(jsonb);
    }

    static JsonbNdBodyStreamWriter create(Jsonb jsonb) {
        return new JsonbNdBodyStreamWriter(jsonb);
    }

    public MessageBodyOperator.PredicateResult accept(GenericType<?> type, MessageBodyWriterContext context) {
        if (CharSequence.class.isAssignableFrom(type.rawType())) {
            return MessageBodyOperator.PredicateResult.NOT_SUPPORTED;
        }
        return context.contentType().or(() -> this.findMediaType(context)).filter(arg_0 -> ((MediaType)MediaType.APPLICATION_X_NDJSON).test(arg_0)).map(it -> MessageBodyOperator.PredicateResult.COMPATIBLE).orElse(MessageBodyOperator.PredicateResult.NOT_SUPPORTED);
    }

    public Multi<DataChunk> write(Flow.Publisher<?> publisher, GenericType<?> type, MessageBodyWriterContext context) {
        MediaType contentType = MediaType.APPLICATION_X_NDJSON;
        context.contentType(contentType);
        AtomicBoolean first = new AtomicBoolean(true);
        return Multi.create(publisher).map(object -> DataChunk.create((byte[])this.jsonb.toJson(object).getBytes(StandardCharsets.UTF_8))).flatMap(dataChunk -> {
            if (first.getAndSet(false)) {
                return Single.just((Object)dataChunk);
            }
            return Multi.just((Object[])new DataChunk[]{DataChunk.create((byte[])NL), dataChunk});
        });
    }

    private Optional<MediaType> findMediaType(MessageBodyWriterContext context) {
        try {
            return Optional.of(context.findAccepted(MediaType.APPLICATION_X_NDJSON));
        }
        catch (IllegalStateException ignore) {
            return Optional.empty();
        }
    }
}

