/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.media.jsonb;

import io.helidon.common.GenericType;
import io.helidon.common.http.DataChunk;
import io.helidon.common.http.MediaType;
import io.helidon.common.reactive.Multi;
import io.helidon.media.common.MessageBodyOperator;
import io.helidon.media.common.MessageBodyStreamWriter;
import io.helidon.media.common.MessageBodyWriterContext;
import jakarta.json.bind.Jsonb;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Flow;

class JsonbEsBodyStreamWriter
implements MessageBodyStreamWriter<Object> {
    private static final MediaType TEXT_EVENT_STREAM_JSON = MediaType.parse((String)"text/event-stream;element-type=\"application/json\"");
    private static final byte[] DATA = "data: ".getBytes(StandardCharsets.UTF_8);
    private static final byte[] NL = "\n\n".getBytes(StandardCharsets.UTF_8);
    private final Jsonb jsonb;

    private JsonbEsBodyStreamWriter(Jsonb jsonb) {
        this.jsonb = Objects.requireNonNull(jsonb);
    }

    static JsonbEsBodyStreamWriter create(Jsonb jsonb) {
        return new JsonbEsBodyStreamWriter(jsonb);
    }

    public MessageBodyOperator.PredicateResult accept(GenericType<?> type, MessageBodyWriterContext context) {
        if (CharSequence.class.isAssignableFrom(type.rawType())) {
            return MessageBodyOperator.PredicateResult.NOT_SUPPORTED;
        }
        return context.contentType().or(() -> this.findMediaType(context)).filter(mediaType -> mediaType.equals((Object)TEXT_EVENT_STREAM_JSON) || mediaType.equals((Object)MediaType.TEXT_EVENT_STREAM)).map(it -> MessageBodyOperator.PredicateResult.COMPATIBLE).orElse(MessageBodyOperator.PredicateResult.NOT_SUPPORTED);
    }

    public Multi<DataChunk> write(Flow.Publisher<?> publisher, GenericType<?> type, MessageBodyWriterContext context) {
        MediaType contentType = context.contentType().or(() -> this.findMediaType(context)).orElse(TEXT_EVENT_STREAM_JSON);
        context.contentType(contentType);
        return Multi.create(publisher).flatMap(m -> Multi.just((Object[])new DataChunk[]{DataChunk.create((byte[])DATA), DataChunk.create((byte[])this.jsonb.toJson(m).getBytes(StandardCharsets.UTF_8)), DataChunk.create((byte[])NL)}));
    }

    private Optional<MediaType> findMediaType(MessageBodyWriterContext context) {
        try {
            return Optional.of(context.findAccepted(MediaType.JSON_EVENT_STREAM_PREDICATE, TEXT_EVENT_STREAM_JSON));
        }
        catch (IllegalStateException ignore) {
            return Optional.empty();
        }
    }
}

