/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.media.jsonb;

import io.helidon.common.HelidonFeatures;
import io.helidon.common.HelidonFlavor;
import io.helidon.common.LazyValue;
import io.helidon.media.common.MediaSupport;
import io.helidon.media.common.MessageBodyReader;
import io.helidon.media.common.MessageBodyWriter;
import io.helidon.media.jsonb.JsonbBodyReader;
import io.helidon.media.jsonb.JsonbBodyWriter;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.json.bind.Jsonb;
import javax.json.bind.JsonbBuilder;

public final class JsonbSupport
implements MediaSupport {
    private static final Jsonb JSON_B;
    private static final LazyValue<JsonbSupport> DEFAULT;
    private final JsonbBodyReader reader;
    private final JsonbBodyWriter writer;

    private JsonbSupport(Jsonb jsonb) {
        this.reader = JsonbBodyReader.create(jsonb);
        this.writer = JsonbBodyWriter.create(jsonb);
    }

    public static JsonbSupport create() {
        return (JsonbSupport)DEFAULT.get();
    }

    public static JsonbSupport create(Jsonb jsonb) {
        Objects.requireNonNull(jsonb);
        return new JsonbSupport(jsonb);
    }

    public static MessageBodyReader<Object> reader() {
        return ((JsonbSupport)JsonbSupport.DEFAULT.get()).reader;
    }

    public static MessageBodyReader<Object> reader(Jsonb jsonb) {
        Objects.requireNonNull(jsonb);
        return JsonbBodyReader.create(jsonb);
    }

    public static MessageBodyWriter<Object> writer() {
        return ((JsonbSupport)JsonbSupport.DEFAULT.get()).writer;
    }

    public static MessageBodyWriter<Object> writer(Jsonb jsonb) {
        Objects.requireNonNull(jsonb);
        return JsonbBodyWriter.create(jsonb);
    }

    public MessageBodyReader<Object> readerInstance() {
        return this.reader;
    }

    public MessageBodyWriter<Object> writerInstance() {
        return this.writer;
    }

    public Collection<MessageBodyReader<?>> readers() {
        return List.of(this.reader);
    }

    public Collection<MessageBodyWriter<?>> writers() {
        return List.of(this.writer);
    }

    static {
        HelidonFeatures.register((HelidonFlavor)HelidonFlavor.SE, (String[])new String[]{"Media", "JSON-B"});
        JSON_B = JsonbBuilder.create();
        DEFAULT = LazyValue.create(() -> new JsonbSupport(JSON_B));
    }
}

