/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.media.jsonb;

import io.helidon.common.GenericType;
import io.helidon.common.http.DataChunk;
import io.helidon.common.http.MediaType;
import io.helidon.common.mapper.Mapper;
import io.helidon.common.reactive.Single;
import io.helidon.media.common.CharBuffer;
import io.helidon.media.common.ContentWriters;
import io.helidon.media.common.MessageBodyOperator;
import io.helidon.media.common.MessageBodyWriter;
import io.helidon.media.common.MessageBodyWriterContext;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Objects;
import java.util.concurrent.Flow;
import java.util.function.Function;
import javax.json.bind.Jsonb;
import javax.json.bind.JsonbException;

class JsonbBodyWriter
implements MessageBodyWriter<Object> {
    private final Jsonb jsonb;

    private JsonbBodyWriter(Jsonb jsonb) {
        Objects.requireNonNull(jsonb);
        this.jsonb = jsonb;
    }

    public MessageBodyOperator.PredicateResult accept(GenericType<?> type, MessageBodyWriterContext context) {
        return !CharSequence.class.isAssignableFrom(type.rawType()) ? MessageBodyOperator.PredicateResult.COMPATIBLE : MessageBodyOperator.PredicateResult.NOT_SUPPORTED;
    }

    public Flow.Publisher<DataChunk> write(Single<? extends Object> content, GenericType<? extends Object> type, MessageBodyWriterContext context) {
        MediaType contentType = context.findAccepted(MediaType.JSON_PREDICATE, MediaType.APPLICATION_JSON);
        context.contentType(contentType);
        return content.flatMap((Function)((Object)new ObjectToChunks(this.jsonb, context.charset())));
    }

    public static JsonbBodyWriter create(Jsonb jsonb) {
        return new JsonbBodyWriter(jsonb);
    }

    private static final class ObjectToChunks
    implements Mapper<Object, Flow.Publisher<DataChunk>> {
        private final Jsonb jsonb;
        private final Charset charset;

        ObjectToChunks(Jsonb jsonb, Charset charset) {
            this.jsonb = jsonb;
            this.charset = charset;
        }

        public Flow.Publisher<DataChunk> map(Object item) {
            CharBuffer buffer = new CharBuffer();
            try {
                this.jsonb.toJson(item, (Writer)buffer);
                return ContentWriters.writeCharBuffer((CharBuffer)buffer, (Charset)this.charset);
            }
            catch (IllegalStateException | JsonbException ex) {
                return Single.error((Throwable)ex);
            }
        }
    }
}

