/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.media.jsonb;

import io.helidon.common.HelidonFeatures;
import io.helidon.common.HelidonFlavor;
import io.helidon.media.common.MediaSupport;
import io.helidon.media.common.MessageBodyReader;
import io.helidon.media.common.MessageBodyWriter;
import io.helidon.media.jsonb.JsonbBodyReader;
import io.helidon.media.jsonb.JsonbBodyWriter;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.json.bind.Jsonb;
import javax.json.bind.JsonbBuilder;

public final class JsonbSupport
implements MediaSupport {
    private static final Jsonb JSON_B;
    private static final JsonbSupport DEFAULT;
    private final Jsonb jsonb;

    private JsonbSupport(Jsonb jsonb) {
        this.jsonb = jsonb;
    }

    public static JsonbBodyReader reader() {
        return JsonbSupport.create().newReader();
    }

    public static JsonbBodyWriter writer() {
        return JsonbSupport.create().newWriter();
    }

    public JsonbBodyReader newReader() {
        return JsonbBodyReader.create(this.jsonb);
    }

    public JsonbBodyWriter newWriter() {
        return JsonbBodyWriter.create(this.jsonb);
    }

    public Collection<MessageBodyReader<?>> readers() {
        return List.of(this.newReader());
    }

    public Collection<MessageBodyWriter<?>> writers() {
        return List.of(this.newWriter());
    }

    public static JsonbSupport create(Jsonb jsonb) {
        Objects.requireNonNull(jsonb);
        return new JsonbSupport(jsonb);
    }

    public static JsonbSupport create() {
        return DEFAULT;
    }

    static {
        HelidonFeatures.register((HelidonFlavor)HelidonFlavor.SE, (String[])new String[]{"Media", "JSON-B"});
        JSON_B = JsonbBuilder.create();
        DEFAULT = new JsonbSupport(JSON_B);
    }
}

