/*
 * Decompiled with CFR 0.152.
 */
package io.hawt.osgi.jmx;

import io.hawt.osgi.jmx.RBACDecoratorMBean;
import java.io.UnsupportedEncodingException;
import java.lang.management.ManagementFactory;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.TabularData;
import org.apache.commons.codec.binary.Hex;
import org.apache.karaf.management.JMXSecurityMBean;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RBACDecorator
implements RBACDecoratorMBean {
    public static Logger LOG = LoggerFactory.getLogger(RBACDecorator.class);
    private static final String JMX_ACL_PID_PREFIX = "jmx.acl";
    private static final String JMX_OBJECTNAME_PROPERTY_WILDCARD = "_";
    private static final Comparator<String[]> WILDCARD_PID_COMPARATOR = new WildcardPidComparator();
    private final BundleContext bundleContext;
    private ObjectName objectName;
    private MBeanServer mBeanServer;
    private boolean verify = false;

    public RBACDecorator(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    void init() throws Exception {
        if (this.objectName == null) {
            this.objectName = new ObjectName("hawtio:type=security,area=jolokia,name=RBACDecorator");
        }
        if (this.mBeanServer == null) {
            this.mBeanServer = ManagementFactory.getPlatformMBeanServer();
        }
        this.mBeanServer.registerMBean(this, this.objectName);
    }

    void destroy() throws Exception {
        if (this.objectName != null && this.mBeanServer != null) {
            this.mBeanServer.unregisterMBean(this.objectName);
        }
    }

    @Override
    public void decorate(Map<String, Object> result) throws Exception {
        try {
            ServiceReference cmRef = this.bundleContext.getServiceReference(ConfigurationAdmin.class);
            ServiceReference jmxSecRef = this.bundleContext.getServiceReference(JMXSecurityMBean.class);
            if (cmRef == null || jmxSecRef == null) {
                return;
            }
            ConfigurationAdmin configAdmin = (ConfigurationAdmin)this.bundleContext.getService(cmRef);
            JMXSecurityMBean jmxSec = (JMXSecurityMBean)this.bundleContext.getService(jmxSecRef);
            if (configAdmin == null || jmxSec == null) {
                return;
            }
            Configuration[] configurations = configAdmin.listConfigurations("(service.pid=jmx.acl*)");
            if (configurations == null) {
                return;
            }
            List allJmxAclPids = Arrays.stream(configurations).map(Configuration::getPid).collect(Collectors.toCollection(LinkedList::new));
            if (allJmxAclPids.isEmpty()) {
                return;
            }
            Map domains = (Map)result.get("domains");
            Map cache = (Map)result.get("cache");
            HashMap<String, Map<String, Object>> rbacCache = new HashMap<String, Map<String, Object>>();
            HashMap<String, List<String>> queryForMBeans = new HashMap<String, List<String>>();
            HashMap<String, List<String>> queryForMBeanOperations = new HashMap<String, List<String>>();
            this.constructQueries(allJmxAclPids, domains, cache, rbacCache, queryForMBeans, queryForMBeanOperations);
            this.doQueryForMBeans(jmxSec, domains, rbacCache, queryForMBeans);
            this.doQueryForMBeanOperations(jmxSec, domains, rbacCache, queryForMBeanOperations);
            result.remove("cache");
            result.put("cache", rbacCache);
            if (this.verify) {
                this.verify(result);
            }
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
    }

    private void constructQueries(List<String> allJmxAclPids, Map<String, Map<String, Object>> domains, Map<String, Map<String, Object>> cache, Map<String, Map<String, Object>> rbacCache, Map<String, List<String>> queryForMBeans, Map<String, List<String>> queryForMBeanOperations) throws MalformedObjectNameException, NoSuchAlgorithmException, UnsupportedEncodingException {
        for (String domain : domains.keySet()) {
            HashMap<String, Object> domainMBeansCheck = new HashMap<String, Object>(domains.get(domain));
            Map<String, Object> domainMBeans = domains.get(domain);
            for (String name : domainMBeansCheck.keySet()) {
                Object mBeanInfo = domainMBeansCheck.get(name);
                String fullName = domain + ":" + name;
                ObjectName oName = new ObjectName(fullName);
                if (mBeanInfo instanceof Map) {
                    this.prepareKarafRbacInvocations(fullName, (Map)mBeanInfo, queryForMBeans, queryForMBeanOperations);
                    continue;
                }
                String key = (String)mBeanInfo;
                String pidListKey = RBACDecorator.pidListKey(allJmxAclPids, oName);
                if (!rbacCache.containsKey(key + ":" + pidListKey)) {
                    Map<String, Object> sharedMBeanAndRbacInfo = RBACDecorator.deepCopy(cache.get(key));
                    rbacCache.put(key + ":" + pidListKey, sharedMBeanAndRbacInfo);
                    this.prepareKarafRbacInvocations(fullName, sharedMBeanAndRbacInfo, queryForMBeans, queryForMBeanOperations);
                }
                domainMBeans.put(name, key + ":" + pidListKey);
            }
        }
    }

    static Map<String, Object> deepCopy(Map<String, Object> mBeanInfo) {
        HashMap<String, Object> copy = new HashMap<String, Object>(mBeanInfo);
        Map ops = (Map)mBeanInfo.get("op");
        HashMap newOps = new HashMap(ops.size());
        for (String name : ops.keySet()) {
            Cloneable newOp;
            Object op = ops.get(name);
            if (op instanceof List) {
                List overloaded = (List)op;
                ArrayList newOpList = new ArrayList(overloaded.size());
                for (Map method : overloaded) {
                    newOpList.add(new HashMap(method));
                }
                newOp = newOpList;
            } else {
                Map method = (Map)op;
                newOp = new HashMap(method);
            }
            newOps.put(name, newOp);
        }
        copy.put("op", newOps);
        return copy;
    }

    private void doQueryForMBeans(JMXSecurityMBean jmxSec, Map<String, Map<String, Object>> domains, Map<String, Map<String, Object>> rbacCache, Map<String, List<String>> queryForMBeans) throws Exception {
        TabularData dataForMBeans = jmxSec.canInvoke(queryForMBeans);
        Collection<?> results = dataForMBeans.values();
        for (Object cd : results) {
            ObjectName objectName = new ObjectName((String)((CompositeData)cd).get("ObjectName"));
            boolean canInvoke = ((CompositeData)cd).get("CanInvoke") != null ? (Boolean)((CompositeData)cd).get("CanInvoke") : false;
            Object mBeanInfoOrKey = domains.get(objectName.getDomain()).get(objectName.getKeyPropertyListString());
            Map<String, Object> mBeanInfo = mBeanInfoOrKey instanceof Map ? (Map<String, Object>)mBeanInfoOrKey : rbacCache.get(mBeanInfoOrKey.toString());
            if (mBeanInfo == null) continue;
            mBeanInfo.put("canInvoke", canInvoke);
        }
    }

    private void doQueryForMBeanOperations(JMXSecurityMBean jmxSec, Map<String, Map<String, Object>> domains, Map<String, Map<String, Object>> rbacCache, Map<String, List<String>> queryForMBeanOperations) throws Exception {
        TabularData dataForMBeanOperations = jmxSec.canInvoke(queryForMBeanOperations);
        Collection<?> results = dataForMBeanOperations.values();
        for (Object result : results) {
            Map<String, Object> mBeanInfo;
            CompositeData cd = (CompositeData)result;
            ObjectName objectName = new ObjectName((String)cd.get("ObjectName"));
            String method = (String)cd.get("Method");
            boolean canInvoke = cd.get("CanInvoke") != null ? (Boolean)cd.get("CanInvoke") : false;
            Object mBeanInfoOrKey = domains.get(objectName.getDomain()).get(objectName.getKeyPropertyListString());
            if (mBeanInfoOrKey instanceof Map) {
                mBeanInfo = (Map<String, Object>)mBeanInfoOrKey;
                LOG.trace("{} {} - {}", new Object[]{objectName, method, canInvoke});
            } else {
                mBeanInfo = rbacCache.get(mBeanInfoOrKey.toString());
                LOG.trace("{} {} - {} - {}", new Object[]{objectName, method, canInvoke, mBeanInfoOrKey.toString()});
            }
            if (mBeanInfo == null) continue;
            this.decorateCanInvoke(mBeanInfo, method, canInvoke);
        }
    }

    private void prepareKarafRbacInvocations(String fullName, Map<String, Object> mBeanInfo, Map<String, List<String>> queryForMBeans, Map<String, List<String>> queryForMBeanOperations) {
        queryForMBeans.put(fullName, new ArrayList());
        List<String> operations = this.operations((Map)mBeanInfo.get("op"));
        HashMap opByString = new HashMap();
        mBeanInfo.put("opByString", opByString);
        if (operations.isEmpty()) {
            return;
        }
        queryForMBeanOperations.put(fullName, operations);
        for (String op : operations) {
            opByString.put(op, new HashMap());
        }
    }

    static String pidListKey(List<String> allJmxAclPids, ObjectName objectName) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        List<String> pidCandidates = RBACDecorator.iterateDownPids(RBACDecorator.nameSegments(objectName));
        MessageDigest md = MessageDigest.getInstance("MD5");
        for (String pc : pidCandidates) {
            String generalPid = RBACDecorator.getGeneralPid(allJmxAclPids, pc);
            if (generalPid.length() <= 0) continue;
            md.update(generalPid.getBytes("UTF-8"));
        }
        return Hex.encodeHexString(md.digest());
    }

    private List<String> operations(Map<String, Object> ops) {
        LinkedList<String> result = new LinkedList<String>();
        for (String operation : ops.keySet()) {
            Object operationOrListOfOperations = ops.get(operation);
            List<Map> toStringify = operationOrListOfOperations instanceof List ? (List<Map>)operationOrListOfOperations : Collections.singletonList((Map)operationOrListOfOperations);
            for (Map op : toStringify) {
                List args = (List)op.get("args");
                result.add(operation + "(" + RBACDecorator.argsToString(args) + ")");
            }
        }
        return result;
    }

    private static String argsToString(List<Map<String, String>> args) {
        if (args == null || args.isEmpty()) {
            return "";
        }
        StringBuilder sb = null;
        for (Map<String, String> arg : args) {
            if (sb == null) {
                sb = new StringBuilder();
            } else {
                sb.append(',');
            }
            sb.append(arg.get("type"));
        }
        return sb.toString();
    }

    static List<String> nameSegments(ObjectName objectName) {
        ArrayList<String> segments = new ArrayList<String>();
        segments.add(objectName.getDomain());
        for (String s : objectName.getKeyPropertyListString().split(",")) {
            int index = s.indexOf(61);
            if (index < 0) continue;
            String key = objectName.getKeyProperty(s.substring(0, index));
            if (s.substring(0, index).equals("type")) {
                segments.add(1, key);
                continue;
            }
            segments.add(key);
        }
        return segments;
    }

    static List<String> iterateDownPids(List<String> segments) {
        ArrayList<String> res = new ArrayList<String>();
        for (int i = segments.size(); i > 0; --i) {
            StringBuilder sb = new StringBuilder();
            sb.append(JMX_ACL_PID_PREFIX);
            for (int j = 0; j < i; ++j) {
                sb.append('.');
                sb.append(segments.get(j));
            }
            res.add(sb.toString());
        }
        res.add(JMX_ACL_PID_PREFIX);
        return res;
    }

    private static String getGeneralPid(List<String> allJmxAclPids, String pid) {
        String[] pidStrArray = pid.split(Pattern.quote("."));
        TreeSet<String[]> rets = new TreeSet<String[]>(WILDCARD_PID_COMPARATOR);
        for (String id : allJmxAclPids) {
            String[] idStrArray = id.split(Pattern.quote("."));
            if (idStrArray.length != pidStrArray.length) continue;
            boolean match = true;
            for (int i = 0; i < idStrArray.length; ++i) {
                if (idStrArray[i].equals(JMX_OBJECTNAME_PROPERTY_WILDCARD) || idStrArray[i].equals(pidStrArray[i])) continue;
                match = false;
                break;
            }
            if (!match) continue;
            rets.add(idStrArray);
        }
        Iterator it = rets.iterator();
        if (!it.hasNext()) {
            return "";
        }
        StringBuilder buffer = new StringBuilder();
        for (String segment : (String[])it.next()) {
            if (buffer.length() > 0) {
                buffer.append(".");
            }
            buffer.append(segment);
        }
        return buffer.toString();
    }

    private void decorateCanInvoke(Map<String, Object> mBeanInfo, String method, boolean canInvoke) {
        LOG.trace("decorateCanInvoke: {} - {}", (Object)method, (Object)canInvoke);
        String[] methodNameAndArgs = method.split("[()]");
        Object op = ((Map)mBeanInfo.get("op")).get(methodNameAndArgs[0]);
        if (op instanceof List) {
            List overloaded = (List)op;
            for (Map m : overloaded) {
                String args = RBACDecorator.argsToString((List)m.get("args"));
                if ((methodNameAndArgs.length != 1 || !args.equals("")) && (methodNameAndArgs.length <= 1 || !args.equals(methodNameAndArgs[1]))) continue;
                m.put("canInvoke", canInvoke);
                LOG.trace("  op: {}({}) - {}", new Object[]{methodNameAndArgs[0], args, m.get("canInvoke")});
                break;
            }
        } else {
            ((Map)op).put("canInvoke", canInvoke);
            LOG.trace("  op: {} - {}", (Object)method, ((Map)op).get("canInvoke"));
        }
        Map opByString = (Map)mBeanInfo.get("opByString");
        Map opByStringMethod = (Map)opByString.get(method);
        opByStringMethod.put("canInvoke", canInvoke);
        LOG.trace("  opByString: {} - {}", (Object)method, opByStringMethod.get("canInvoke"));
    }

    private void verify(Map<String, Object> result) {
        LOG.debug("Verifying result...");
        Map domains = (Map)result.get("domains");
        for (String domain : domains.keySet()) {
            Map mBeans = (Map)domains.get(domain);
            for (String propertyList : mBeans.keySet()) {
                Object mBeanInfo = mBeans.get(propertyList);
                if (!(mBeanInfo instanceof Map)) continue;
                this.doVerifyRBAC((Map)mBeanInfo);
            }
        }
        Map cache = (Map)result.get("cache");
        for (String key : cache.keySet()) {
            this.doVerifyRBAC((Map)cache.get(key));
        }
        LOG.debug("Verification done");
    }

    private void doVerifyRBAC(Map<String, Object> mBeanInfo) {
        Map ops = (Map)mBeanInfo.get("op");
        Map opByStrings = (Map)mBeanInfo.get("opByString");
        for (String name : ops.keySet()) {
            Object op = ops.get(name);
            if (op instanceof List) {
                List overloaded = (List)op;
                for (Map method : overloaded) {
                    this.doVerifyCanInvoke(opByStrings, name, method);
                }
                continue;
            }
            Map method = (Map)op;
            this.doVerifyCanInvoke(opByStrings, name, method);
        }
    }

    private void doVerifyCanInvoke(Map<String, Object> opByStrings, String name, Map<String, Object> method) {
        boolean canInvoke1 = (Boolean)method.get("canInvoke");
        String args = RBACDecorator.argsToString((List)method.get("args"));
        String opByStringName = name + "(" + args + ")";
        Map opByString = (Map)opByStrings.get(opByStringName);
        boolean canInvoke2 = (Boolean)opByString.get("canInvoke");
        if (canInvoke1 != canInvoke2) {
            LOG.error("canInvoke doesn't match: {} - {}, {}", new Object[]{opByStringName, canInvoke1, canInvoke2});
        }
    }

    @Override
    public boolean getVerify() {
        return this.verify;
    }

    @Override
    public void setVerify(boolean verify) {
        this.verify = verify;
    }

    private static class WildcardPidComparator
    implements Comparator<String[]> {
        private WildcardPidComparator() {
        }

        @Override
        public int compare(String[] o1, String[] o2) {
            if (o1 == null && o2 == null) {
                return 0;
            }
            if (o1 == null) {
                return 1;
            }
            if (o2 == null) {
                return -1;
            }
            if (o1.length != o2.length) {
                return o1.length - o2.length;
            }
            for (int n = 0; n < o1.length; ++n) {
                if (o1[n].equals(o2[n])) continue;
                if (o1[n].equals(RBACDecorator.JMX_OBJECTNAME_PROPERTY_WILDCARD)) {
                    return 1;
                }
                if (o2[n].equals(RBACDecorator.JMX_OBJECTNAME_PROPERTY_WILDCARD)) {
                    return -1;
                }
                return o1[n].compareTo(o2[n]);
            }
            return 0;
        }
    }
}

