/*
 * Decompiled with CFR 0.152.
 */
package io.hawt.osgi.jmx;

import io.hawt.osgi.jmx.RBACDecoratorMBean;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.lang.management.ManagementFactory;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.regex.Pattern;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.TabularData;
import org.apache.commons.codec.binary.Hex;
import org.apache.karaf.management.JMXSecurityMBean;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RBACDecorator
implements RBACDecoratorMBean {
    public static Logger LOG = LoggerFactory.getLogger(RBACDecorator.class);
    private static final String JMX_ACL_PID_PREFIX = "jmx.acl";
    private static final String JMX_OBJECTNAME_PROPERTY_WILDCARD = "_";
    private static final Comparator<String[]> WILDCARD_PID_COMPARATOR = new WildcardPidComparator();
    private final BundleContext bundleContext;
    private ObjectName objectName;
    private MBeanServer mBeanServer;

    public RBACDecorator(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    void init() throws Exception {
        if (this.objectName == null) {
            this.objectName = new ObjectName("hawtio:type=security,area=jolokia,name=RBACDecorator");
        }
        if (this.mBeanServer == null) {
            this.mBeanServer = ManagementFactory.getPlatformMBeanServer();
        }
        this.mBeanServer.registerMBean(this, this.objectName);
    }

    void destroy() throws Exception {
        if (this.objectName != null && this.mBeanServer != null) {
            this.mBeanServer.unregisterMBean(this.objectName);
        }
    }

    @Override
    public void decorate(Map<String, Object> result) throws Exception {
        try {
            ServiceReference cmRef = this.bundleContext.getServiceReference(ConfigurationAdmin.class);
            ServiceReference jmxSecRef = this.bundleContext.getServiceReference(JMXSecurityMBean.class);
            if (cmRef != null && jmxSecRef != null) {
                ConfigurationAdmin configAdmin = (ConfigurationAdmin)this.bundleContext.getService(cmRef);
                JMXSecurityMBean jmxSec = (JMXSecurityMBean)this.bundleContext.getService(jmxSecRef);
                if (configAdmin != null && jmxSec != null) {
                    Configuration[] configurations = configAdmin.listConfigurations("(service.pid=jmx.acl*)");
                    LinkedList<String> allJmxAclPids = new LinkedList<String>();
                    for (Configuration cfg : configurations) {
                        allJmxAclPids.add(cfg.getPid());
                    }
                    if (allJmxAclPids.size() == 0) {
                        return;
                    }
                    Map domains = (Map)result.get("domains");
                    Map cache = (Map)result.get("cache");
                    HashMap<String, HashMap<String, Object>> rbacCache = new HashMap<String, HashMap<String, Object>>();
                    HashMap<String, List<String>> queryForMBeans = new HashMap<String, List<String>>();
                    HashMap<String, List<String>> queryForMBeanOperations = new HashMap<String, List<String>>();
                    for (String domain : domains.keySet()) {
                        HashMap domainMBeansCheck = new HashMap((Map)domains.get(domain));
                        Map domainMBeans = (Map)domains.get(domain);
                        for (String name : domainMBeansCheck.keySet()) {
                            Object mBeanInfo = domainMBeansCheck.get(name);
                            String fullName = domain + ":" + name;
                            ObjectName n = new ObjectName(fullName);
                            if (mBeanInfo instanceof Map) {
                                this.prepareKarafRbacInvocations(fullName, (Map)mBeanInfo, queryForMBeans, queryForMBeanOperations);
                                continue;
                            }
                            String key = (String)mBeanInfo;
                            String pidListKey = RBACDecorator.pidListKey(allJmxAclPids, n);
                            if (!rbacCache.containsKey(key + ":" + pidListKey)) {
                                HashMap<String, Object> sharedMBeanAndRbacInfo = new HashMap<String, Object>((Map)cache.get(key));
                                rbacCache.put(key + ":" + pidListKey, sharedMBeanAndRbacInfo);
                                this.prepareKarafRbacInvocations(fullName, sharedMBeanAndRbacInfo, queryForMBeans, queryForMBeanOperations);
                            }
                            domainMBeans.put(name, key + ":" + pidListKey);
                        }
                    }
                    TabularData dataForMBeans = jmxSec.canInvoke(queryForMBeans);
                    Collection<?> results = dataForMBeans.values();
                    for (Object cd : results) {
                        ObjectName objectName = new ObjectName((String)((CompositeData)cd).get("ObjectName"));
                        boolean canInvoke = ((CompositeData)cd).get("CanInvoke") != null ? (Boolean)((CompositeData)cd).get("CanInvoke") : false;
                        Object mBeanInfoOrKey = ((Map)domains.get(objectName.getDomain())).get(objectName.getKeyPropertyListString());
                        Map mBeanInfo = mBeanInfoOrKey instanceof Map ? (Map)mBeanInfoOrKey : (Map)rbacCache.get(mBeanInfoOrKey.toString());
                        if (mBeanInfo == null) continue;
                        mBeanInfo.put("canInvoke", canInvoke);
                    }
                    TabularData dataForMBeanOperations = jmxSec.canInvoke(queryForMBeanOperations);
                    results = dataForMBeanOperations.values();
                    for (Object cd : results) {
                        ObjectName objectName = new ObjectName((String)((CompositeData)cd).get("ObjectName"));
                        String method = (String)((CompositeData)cd).get("Method");
                        boolean canInvoke = ((CompositeData)cd).get("CanInvoke") != null ? (Boolean)((CompositeData)cd).get("CanInvoke") : false;
                        Object mBeanInfoOrKey = ((Map)domains.get(objectName.getDomain())).get(objectName.getKeyPropertyListString());
                        Map mBeanInfo = mBeanInfoOrKey instanceof Map ? (Map)mBeanInfoOrKey : (Map)rbacCache.get(mBeanInfoOrKey.toString());
                        if (mBeanInfo == null) continue;
                        this.decorateCanInvoke(mBeanInfo, method, canInvoke);
                    }
                    result.remove("cache");
                    result.put("cache", rbacCache);
                }
            }
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
    }

    private void prepareKarafRbacInvocations(String fullName, Map<String, Object> mBeanInfo, Map<String, List<String>> queryForMBeans, Map<String, List<String>> queryForMBeanOperations) {
        queryForMBeans.put(fullName, new ArrayList());
        List<String> operations = this.operations((Map)mBeanInfo.get("op"));
        HashMap opByString = new HashMap();
        mBeanInfo.put("opByString", opByString);
        if (operations.size() > 0) {
            queryForMBeanOperations.put(fullName, operations);
            for (String op : operations) {
                opByString.put(op, new HashMap());
            }
        }
    }

    public static String pidListKey(List<String> allJmxAclPids, ObjectName n) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        List<String> pidCandidates = RBACDecorator.iterateDownPids(RBACDecorator.nameSegments(n));
        MessageDigest md = MessageDigest.getInstance("MD5");
        for (String pc : pidCandidates) {
            String generalPid = RBACDecorator.getGeneralPid(allJmxAclPids, pc);
            if (generalPid.length() <= 0) continue;
            md.update(generalPid.getBytes("UTF-8"));
        }
        return Hex.encodeHexString(md.digest());
    }

    private List<String> operations(Map<String, Object> ops) {
        LinkedList<String> result = new LinkedList<String>();
        for (String operation : ops.keySet()) {
            Object operationOrListOfOperations = ops.get(operation);
            List<Map> toStringify = operationOrListOfOperations instanceof List ? (List<Map>)operationOrListOfOperations : Collections.singletonList((Map)operationOrListOfOperations);
            for (Map op : toStringify) {
                List args = (List)op.get("args");
                result.add(operation + "(" + RBACDecorator.argsToString(args) + ")");
            }
        }
        return result;
    }

    private static String argsToString(List<Map<String, String>> args) {
        if (args == null || args.size() == 0) {
            return "";
        }
        StringWriter sw = null;
        for (Map<String, String> arg : args) {
            if (sw == null) {
                sw = new StringWriter();
            } else {
                sw.append(',');
            }
            sw.append(arg.get("type"));
        }
        return sw.toString();
    }

    public static List<String> nameSegments(ObjectName objectName) {
        ArrayList<String> segments = new ArrayList<String>();
        segments.add(objectName.getDomain());
        for (String s : objectName.getKeyPropertyListString().split(",")) {
            int index = s.indexOf(61);
            if (index < 0) continue;
            String key = objectName.getKeyProperty(s.substring(0, index));
            if (s.substring(0, index).equals("type")) {
                segments.add(1, key);
                continue;
            }
            segments.add(key);
        }
        return segments;
    }

    public static List<String> iterateDownPids(List<String> segments) {
        ArrayList<String> res = new ArrayList<String>();
        for (int i = segments.size(); i > 0; --i) {
            StringBuilder sb = new StringBuilder();
            sb.append(JMX_ACL_PID_PREFIX);
            for (int j = 0; j < i; ++j) {
                sb.append('.');
                sb.append(segments.get(j));
            }
            res.add(sb.toString());
        }
        res.add(JMX_ACL_PID_PREFIX);
        return res;
    }

    private static String getGeneralPid(List<String> allJmxAclPids, String pid) {
        String[] pidStrArray = pid.split(Pattern.quote("."));
        TreeSet<String[]> rets = new TreeSet<String[]>(WILDCARD_PID_COMPARATOR);
        for (String id : allJmxAclPids) {
            String[] idStrArray = id.split(Pattern.quote("."));
            if (idStrArray.length != pidStrArray.length) continue;
            boolean match = true;
            for (int i = 0; i < idStrArray.length; ++i) {
                if (idStrArray[i].equals(JMX_OBJECTNAME_PROPERTY_WILDCARD) || idStrArray[i].equals(pidStrArray[i])) continue;
                match = false;
                break;
            }
            if (!match) continue;
            rets.add(idStrArray);
        }
        Iterator it = rets.iterator();
        if (!it.hasNext()) {
            return "";
        }
        StringBuilder buffer = new StringBuilder();
        for (String segment : (String[])it.next()) {
            if (buffer.length() > 0) {
                buffer.append(".");
            }
            buffer.append(segment);
        }
        return buffer.toString();
    }

    public static boolean mayShareRBACInfo(List<String> realJmxAclPids, ObjectName o1, ObjectName o2) {
        if (o1 == null || o2 == null) {
            return false;
        }
        LinkedList<String> pids1 = new LinkedList<String>();
        List<String> pidCandidates1 = RBACDecorator.iterateDownPids(RBACDecorator.nameSegments(o1));
        List<String> pidCandidates2 = RBACDecorator.iterateDownPids(RBACDecorator.nameSegments(o2));
        for (String pidCandidate1 : pidCandidates1) {
            pids1.add(RBACDecorator.getGeneralPid(realJmxAclPids, pidCandidate1));
        }
        for (String pidCandidate2 : pidCandidates2) {
            if (pids1.peek() != null && ((String)pids1.pop()).equals(RBACDecorator.getGeneralPid(realJmxAclPids, pidCandidate2))) continue;
            return false;
        }
        return pids1.size() == 0;
    }

    private void decorateCanInvoke(Map<String, Object> mBeanInfo, String method, boolean canInvoke) {
        String[] methodNameAndArgs = method.split("[()]");
        Object op = ((Map)mBeanInfo.get("op")).get(methodNameAndArgs[0]);
        if (op instanceof List) {
            List overloaded = (List)op;
            for (Map m : overloaded) {
                String args = RBACDecorator.argsToString((List)m.get("args"));
                if ((methodNameAndArgs.length != 1 || !args.equals("")) && (methodNameAndArgs.length <= 1 || !args.equals(methodNameAndArgs[1]))) continue;
                m.put("canInvoke", canInvoke);
                break;
            }
        } else {
            ((Map)op).put("canInvoke", canInvoke);
        }
        ((Map)((Map)mBeanInfo.get("opByString")).get(method)).put("canInvoke", canInvoke);
    }

    private static class WildcardPidComparator
    implements Comparator<String[]> {
        private WildcardPidComparator() {
        }

        @Override
        public int compare(String[] o1, String[] o2) {
            if (o1 == null && o2 == null) {
                return 0;
            }
            if (o1 == null) {
                return 1;
            }
            if (o2 == null) {
                return -1;
            }
            if (o1.length != o2.length) {
                return o1.length - o2.length;
            }
            for (int n = 0; n < o1.length; ++n) {
                if (o1[n].equals(o2[n])) continue;
                if (o1[n].equals(RBACDecorator.JMX_OBJECTNAME_PROPERTY_WILDCARD)) {
                    return 1;
                }
                if (o2[n].equals(RBACDecorator.JMX_OBJECTNAME_PROPERTY_WILDCARD)) {
                    return -1;
                }
                return o1[n].compareTo(o2[n]);
            }
            return 0;
        }
    }
}

