/*
 * Decompiled with CFR 0.152.
 */
package io.hawt.osgi.jmx;

import io.hawt.osgi.jmx.ConfigAdminMXBean;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.util.Hashtable;
import java.util.Map;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigAdmin
implements ConfigAdminMXBean {
    private final BundleContext bundleContext;
    private ObjectName objectName;
    private MBeanServer mBeanServer;

    ConfigAdmin(BundleContext bc) {
        this.bundleContext = bc;
    }

    void init() throws Exception {
        if (this.objectName == null) {
            this.objectName = new ObjectName("io.hawt.osgi:type=ConfigAdmin");
        }
        if (this.mBeanServer == null) {
            this.mBeanServer = ManagementFactory.getPlatformMBeanServer();
        }
        this.mBeanServer.registerMBean(this, this.objectName);
    }

    void destroy() throws Exception {
        if (this.objectName != null && this.mBeanServer != null) {
            this.mBeanServer.unregisterMBean(this.objectName);
        }
    }

    @Override
    public void configAdminUpdate(String pid, Map<String, String> data) {
        ServiceReference sref = this.bundleContext.getServiceReference(ConfigurationAdmin.class.getName());
        if (sref == null) {
            throw new IllegalStateException("The configuration admin service cannot be found.");
        }
        try {
            ConfigurationAdmin ca = (ConfigurationAdmin)this.bundleContext.getService(sref);
            if (ca == null) {
                throw new IllegalStateException("The configuration admin service cannot be found.");
            }
            Configuration config = ca.getConfiguration(pid);
            config.update(new Hashtable<String, String>(data));
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        finally {
            this.bundleContext.ungetService(sref);
        }
    }
}

