/*
 * Decompiled with CFR 0.152.
 */
package io.hawt.embedded;

import io.hawt.embedded.Main;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.HashSet;
import java.util.Set;

public class HawtioDefaultLocator {
    private static final String WAR_FILENAME = "hawtio.war";
    private static final int KB = 1024;

    public static void setWar(Main main) {
        try {
            block19: {
                String virtualMachineClass = "com.sun.tools.attach.VirtualMachine";
                try {
                    HawtioDefaultLocator.loadClass(virtualMachineClass, HawtioDefaultLocator.class.getClassLoader(), Thread.currentThread().getContextClassLoader());
                }
                catch (Exception e) {
                    HashSet<String> paths = new HashSet<String>();
                    String javaHome = System.getProperty("java.home", ".");
                    HawtioDefaultLocator.addPath(paths, javaHome);
                    javaHome = System.getenv("JAVA_HOME");
                    if (javaHome != null && !javaHome.isEmpty()) {
                        HawtioDefaultLocator.addPath(paths, javaHome);
                    }
                    boolean found = false;
                    for (String path : paths) {
                        String normalizedPath = Paths.get(path, new String[0]).normalize().toString();
                        File file = new File(normalizedPath, "lib/tools.jar");
                        if (!file.exists()) continue;
                        found = true;
                        String url = file.toURI().toURL().toString();
                        main.setExtraClassPath(url);
                        break;
                    }
                    if (found) break block19;
                    System.err.printf("Failed to load class %s and find tools.jar in directories %s. %s%n", virtualMachineClass, paths, e);
                }
            }
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            URL resource = classLoader.getResource(WAR_FILENAME);
            if (resource == null) {
                System.err.printf("Could not find the %s on classpath!%n", WAR_FILENAME);
                System.exit(1);
            }
            File warFile = File.createTempFile("hawtio-", ".war");
            try (InputStream in = resource.openStream();
                 OutputStream out = Files.newOutputStream(warFile.toPath(), new OpenOption[0]);){
                HawtioDefaultLocator.writeStreamTo(in, out, 65536);
            }
            String warPath = warFile.getCanonicalPath();
            main.setWar(warPath);
        }
        catch (Exception e) {
            System.err.println("Failed to create hawtio: " + e.getMessage());
            e.printStackTrace();
        }
    }

    protected static void addPath(Set<String> paths, String path) {
        paths.add(path);
        String jreSuffix = File.separator + "jre";
        if (path.endsWith(jreSuffix)) {
            path = path.substring(0, path.length() - jreSuffix.length());
            paths.add(path);
        }
    }

    private static void loadClass(String name, ClassLoader ... classLoaders) throws ClassNotFoundException {
        for (ClassLoader classLoader : classLoaders) {
            try {
                classLoader.loadClass(name);
                return;
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
        }
        Class.forName(name);
    }

    public static void writeStreamTo(InputStream input, OutputStream output, int bufferSize) throws IOException {
        int available = Math.min(input.available(), 262144);
        byte[] buffer = new byte[Math.max(bufferSize, available)];
        int count = input.read(buffer);
        while (count >= 0) {
            output.write(buffer, 0, count);
            count = input.read(buffer);
        }
    }
}

