/*
 * Decompiled with CFR 0.152.
 */
package io.hawt.connect;

import java.util.Map;
import java.util.Optional;
import org.jolokia.json.JSONArray;
import org.jolokia.json.JSONObject;

public class Connection {
    public static final String HAWTIO_CONNECT_PRESET_CONNECTIONS = "hawtio.connect.presetConnections";
    private final boolean https;
    private final String host;
    private final int port;
    private final String path;

    public Connection(boolean https, String host, int port, String path) {
        this.https = https;
        this.host = host;
        this.port = port;
        this.path = path;
    }

    public static void setSystemProperty(Map<String, Optional<Connection>> connections) {
        JSONArray json = new JSONArray();
        connections.forEach((name, conn) -> json.add(conn.map(c -> c.toJSON((String)name)).orElse(Connection.toNameOnly(name))));
        System.setProperty(HAWTIO_CONNECT_PRESET_CONNECTIONS, json.toJSONString());
    }

    private static JSONObject toNameOnly(String name) {
        JSONObject json = new JSONObject();
        json.put("name", name);
        return json;
    }

    public JSONObject toJSON(String name) {
        JSONObject json = new JSONObject();
        json.put("name", name);
        json.put("scheme", this.https ? "https" : "http");
        json.put("host", this.host);
        json.put("port", this.port);
        json.put("path", this.path);
        return json;
    }

    public boolean isHttps() {
        return this.https;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getPath() {
        return this.path;
    }
}

