/*
 * Decompiled with CFR 0.152.
 */
package io.gumga.application.service;

import io.gumga.application.service.AbstractGumgaService;
import io.gumga.core.GumgaIdable;
import io.gumga.core.QueryObject;
import io.gumga.core.SearchResult;
import io.gumga.domain.repository.GumgaCrudRepository;
import io.gumga.domain.service.GumgaReadableServiceable;
import io.gumga.domain.service.GumgaWritableServiceable;
import java.io.Serializable;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Scope(value="prototype")
public abstract class GumgaNoDeleteService<T extends GumgaIdable<ID>, ID extends Serializable>
extends AbstractGumgaService<T, ID>
implements GumgaReadableServiceable<T, ID>,
GumgaWritableServiceable<T, ID> {
    public GumgaNoDeleteService(GumgaCrudRepository<T, ID> repository) {
        super(repository);
    }

    public void beforePesquisa(QueryObject query) {
    }

    public void afterPesquisa(SearchResult<T> result) {
    }

    @Transactional(readOnly=true)
    public SearchResult<T> pesquisa(QueryObject query) {
        this.beforePesquisa(query);
        SearchResult result = this.repository.search(query);
        this.afterPesquisa(result);
        return result;
    }

    public void beforeView(ID id) {
    }

    public void afterView(T entity) {
    }

    @Transactional(readOnly=true)
    public T view(ID id) {
        this.beforeView(id);
        GumgaIdable entity = (GumgaIdable)this.repository.findOne(id);
        this.loadGumgaCustomFields(entity);
        this.afterView(entity);
        return (T)entity;
    }

    private void beforeSaveOrUpdate(T entity) {
        if (entity.getId() == null) {
            this.beforeSave(entity);
        } else {
            this.beforeUpdate(entity);
        }
    }

    private void afterSaveOrUpdate(T entity) {
        if (entity.getId() == null) {
            this.afterSave(entity);
        } else {
            this.afterUpdate(entity);
        }
    }

    public void beforeSave(T entity) {
    }

    public void beforeUpdate(T entity) {
    }

    public void afterSave(T entity) {
    }

    public void afterUpdate(T entity) {
    }

    @Transactional
    public T save(T resource) {
        this.beforeSaveOrUpdate(resource);
        GumgaIdable entity = (GumgaIdable)this.repository.save(resource);
        this.gces.saveCustomFields((GumgaIdable)resource);
        this.afterSaveOrUpdate(entity);
        return (T)entity;
    }

    public void forceFlush() {
        this.repository.flush();
    }
}

