/*
 * Decompiled with CFR 0.152.
 */
package io.gumga.application;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.persistence.Entity;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.lucene.search.Query;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.metadata.ClassMetadata;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.jpa.FullTextEntityManager;
import org.hibernate.search.jpa.FullTextQuery;
import org.hibernate.search.jpa.Search;
import org.hibernate.search.query.dsl.QueryBuilder;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Scope(value="prototype")
public class GumgaUntypedRepository {
    @PersistenceContext
    private EntityManager em;

    @Transactional
    public void save(Object obj) {
        this.em.persist(obj);
    }

    public List<Object> fullTextSearchaaa(String text, Class entidade, String ... atributos) {
        FullTextEntityManager fullTextEntityManager = Search.getFullTextEntityManager((EntityManager)this.em);
        QueryBuilder qb = fullTextEntityManager.getSearchFactory().buildQueryBuilder().forEntity(entidade).get();
        Query query = qb.keyword().onFields(atributos).matching((Object)text).createQuery();
        return fullTextEntityManager.createFullTextQuery(query, new Class[]{entidade}).getResultList();
    }

    @Transactional(readOnly=true)
    public List<Object> fullTextSearch(String text) {
        ArrayList<Object> aRetornar = new ArrayList<Object>();
        for (Class entidade : this.getAllIndexedEntities()) {
            FullTextEntityManager fullTextEntityManager = Search.getFullTextEntityManager((EntityManager)this.em);
            QueryBuilder qb = fullTextEntityManager.getSearchFactory().buildQueryBuilder().forEntity(entidade).get();
            String atributos = "";
            List<Field> todosAtributos = GumgaUntypedRepository.getTodosAtributos(entidade);
            for (Field f : todosAtributos) {
                if (!f.isAnnotationPresent(org.hibernate.search.annotations.Field.class)) continue;
                atributos = atributos + f.getName() + ",";
            }
            if (atributos.isEmpty()) continue;
            atributos = atributos.substring(0, atributos.length() - 1);
            Query query = qb.keyword().onFields(atributos.split(",")).matching((Object)text).createQuery();
            FullTextQuery fullTextQuery = fullTextEntityManager.createFullTextQuery(query, new Class[]{entidade});
            List resultList = fullTextQuery.getResultList();
            aRetornar.addAll(resultList);
        }
        return aRetornar;
    }

    public static List<Field> getTodosAtributos(Class classe) throws SecurityException {
        ArrayList<Field> aRetornar = new ArrayList<Field>();
        if (!classe.getSuperclass().equals(Object.class)) {
            aRetornar.addAll(GumgaUntypedRepository.getTodosAtributos(classe.getSuperclass()));
        }
        aRetornar.addAll(Arrays.asList(classe.getDeclaredFields()));
        return aRetornar;
    }

    @Transactional(readOnly=true)
    private List<Class> getAllIndexedEntities() {
        ArrayList<Class> aRetornar = new ArrayList<Class>();
        EntityManager entityManager = this.em.getEntityManagerFactory().createEntityManager();
        Session session = (Session)entityManager.unwrap(Session.class);
        SessionFactory sessionFactory = session.getSessionFactory();
        Map map = sessionFactory.getAllClassMetadata();
        for (String k : map.keySet()) {
            Class mappedClass = ((ClassMetadata)map.get(k)).getMappedClass();
            if (!mappedClass.isAnnotationPresent(Entity.class) || !mappedClass.isAnnotationPresent(Indexed.class)) continue;
            aRetornar.add(mappedClass);
        }
        return aRetornar;
    }
}

