/*
 * Decompiled with CFR 0.152.
 */
package io.gumga.application;

import com.google.common.base.Strings;
import io.gumga.application.GumgaGenericRepositoryException;
import io.gumga.application.GumgaGenericRepositoryHelper;
import io.gumga.core.GumgaThreadScope;
import io.gumga.core.QueryObject;
import io.gumga.core.SearchResult;
import io.gumga.core.TenancyPublicMarking;
import io.gumga.core.gquery.GQuery;
import io.gumga.domain.GumgaModel;
import io.gumga.domain.GumgaModelUUID;
import io.gumga.domain.GumgaMultitenancy;
import io.gumga.domain.GumgaObjectAndRevision;
import io.gumga.domain.GumgaQueryParserProvider;
import io.gumga.domain.GumgaRevisionEntity;
import io.gumga.domain.GumgaSharedModelUUID;
import io.gumga.domain.HibernateQueryObject;
import io.gumga.domain.Pesquisa;
import io.gumga.domain.logicaldelete.GumgaLDModel;
import io.gumga.domain.repository.GumgaCrudRepository;
import io.gumga.domain.repository.GumgaMultitenancyUtil;
import io.gumga.domain.shared.GumgaSharedModel;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.EntityNotFoundException;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Disjunction;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.hibernate.envers.AuditReader;
import org.hibernate.envers.AuditReaderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.data.jpa.repository.support.CrudMethodMetadata;
import org.springframework.data.jpa.repository.support.JpaEntityInformation;
import org.springframework.data.jpa.repository.support.SimpleJpaRepository;
import org.springframework.data.repository.NoRepositoryBean;
import org.springframework.util.StringUtils;

@NoRepositoryBean
public class GumgaGenericRepository<T, ID extends Serializable>
extends SimpleJpaRepository<T, ID>
implements GumgaCrudRepository<T, ID> {
    protected final JpaEntityInformation<T, ID> entityInformation;
    protected final EntityManager entityManager;
    private static final Logger log = LoggerFactory.getLogger(GumgaGenericRepository.class);

    public GumgaGenericRepository(JpaEntityInformation<T, ID> entityInformation, EntityManager entityManager) {
        super(entityInformation, entityManager);
        this.entityManager = entityManager;
        this.entityInformation = entityInformation;
    }

    public SearchResult<T> search(QueryObject query) {
        if (GumgaQueryParserProvider.defaultMap.equals(GumgaQueryParserProvider.getOracleLikeMapWithAdjust())) {
            log.warn("ORACLE ADJUST");
            this.entityManager.createNativeQuery("alter session set nls_comp=linguistic").executeUpdate();
            this.entityManager.createNativeQuery("alter session set nls_sort=latin_ai").executeUpdate();
            this.entityManager.createNativeQuery("alter session set nls_date_format = 'YYYY-MM-DD'").executeUpdate();
            this.entityManager.createNativeQuery("alter session set nls_timestamp_format = 'YYYY-MM-DD HH24:MI:SS'").executeUpdate();
        }
        if (query.isGQuery()) {
            return this.findByGQuery(query);
        }
        if (query.isAQO()) {
            return this.aqoSearch(query);
        }
        if (query.isAdvanced()) {
            return this.advancedSearch(query);
        }
        Long count = 0L;
        if (query.isSearchCount()) {
            count = this.count(query);
        }
        List data = query.isCountOnly() ? Collections.emptyList() : this.getOrdered(query);
        return new SearchResult(query, (Number)count, data);
    }

    public SearchResult<T> aqoSearch(QueryObject query) {
        query.setAq(GumgaGenericRepositoryHelper.hql(query.getAqo()));
        return this.advancedSearch(query);
    }

    private List<T> getOrdered(QueryObject query) {
        Pesquisa<T> pesquisa = this.getPesquisa(query);
        String sortField = query.getSortField();
        String sortType = query.getSortDir();
        if (!sortField.isEmpty()) {
            this.createAliasIfNecessary(pesquisa, sortField);
            this.getOrderField(pesquisa, sortField, sortType);
        } else {
            pesquisa.addOrder(Order.asc((String)"id"));
        }
        return pesquisa.setFirstResult(query.getStart()).setMaxResults(query.getPageSize()).list();
    }

    private Long count(QueryObject query) {
        Object uniqueResult = this.getPesquisa(query).setProjection(Projections.rowCount()).uniqueResult();
        return uniqueResult == null ? 0L : ((Number)uniqueResult).longValue();
    }

    private Pesquisa<T> getPesquisa(QueryObject query) {
        if (query.getQ() == null && !query.isAdvanced()) {
            throw new IllegalArgumentException("Para realizar a pesquisa simples, q n\u00e3o pode ser nulo.");
        }
        if (query.getSearchFields() != null && query.getSearchFields().length == 0) {
            throw new IllegalArgumentException("Para realizar a search deve se informar pelo menos um campo a ser pesquisado.");
        }
        Criterion[] fieldsCriterions = new HibernateQueryObject(query).getCriterions(this.entityInformation.getJavaType());
        Pesquisa pesquisa = this.search().add((Criterion)Restrictions.or((Criterion[])fieldsCriterions));
        if (this.hasMultitenancy() && GumgaThreadScope.organizationCode.get() != null) {
            Object multitenancyCriterion;
            String oiPattern = GumgaMultitenancyUtil.getMultitenancyPattern((GumgaMultitenancy)this.entityInformation.getJavaType().getAnnotation(GumgaMultitenancy.class));
            GumgaMultitenancy gumgaMultitenancy = this.getDomainClass().getAnnotation(GumgaMultitenancy.class);
            if (GumgaSharedModel.class.isAssignableFrom(this.entityInformation.getJavaType()) || GumgaSharedModelUUID.class.isAssignableFrom(this.entityInformation.getJavaType())) {
                String instanceOi = (String)GumgaThreadScope.instanceOi.get() + "GLOBAL.";
                Disjunction sharedCriterion = Restrictions.or((Criterion[])new Criterion[]{Restrictions.like((String)"gumgaOrganizations", (String)("," + oiPattern + ","), (MatchMode)MatchMode.ANYWHERE), Restrictions.like((String)"gumgaOrganizations", (String)("," + instanceOi + ","), (MatchMode)MatchMode.ANYWHERE), Restrictions.like((String)"gumgaUsers", (String)("," + (String)GumgaThreadScope.login.get() + ","), (MatchMode)MatchMode.ANYWHERE)});
                multitenancyCriterion = gumgaMultitenancy.allowPublics() ? (gumgaMultitenancy.publicMarking() == TenancyPublicMarking.NULL ? Restrictions.or((Criterion[])new Criterion[]{Restrictions.like((String)"oi", (String)oiPattern, (MatchMode)MatchMode.START), Restrictions.isNull((String)"oi"), sharedCriterion}) : Restrictions.or((Criterion[])new Criterion[]{Restrictions.like((String)"oi", (String)oiPattern, (MatchMode)MatchMode.START), Restrictions.eq((String)"oi", (Object)gumgaMultitenancy.publicMarking().getMark()), sharedCriterion})) : Restrictions.or((Criterion)Restrictions.like((String)"oi", (String)oiPattern, (MatchMode)MatchMode.START), (Criterion)sharedCriterion);
            } else {
                multitenancyCriterion = gumgaMultitenancy.allowPublics() ? (gumgaMultitenancy.publicMarking() == TenancyPublicMarking.NULL ? Restrictions.or((Criterion)Restrictions.like((String)"oi", (String)oiPattern, (MatchMode)MatchMode.START), (Criterion)Restrictions.isNull((String)"oi")) : Restrictions.or((Criterion)Restrictions.like((String)"oi", (String)oiPattern, (MatchMode)MatchMode.START), (Criterion)Restrictions.eq((String)"oi", (Object)gumgaMultitenancy.publicMarking().getMark()))) : Restrictions.or((Criterion[])new Criterion[]{Restrictions.like((String)"oi", (String)oiPattern, (MatchMode)MatchMode.START)});
            }
            pesquisa.add((Criterion)multitenancyCriterion);
        }
        if (this.hasLogicalDelete()) {
            pesquisa.add((Criterion)Restrictions.eq((String)"gumgaActive", (Object)(!query.isInactiveSearch() ? 1 : 0)));
        }
        if (query.getSearchFields() != null) {
            for (String field : query.getSearchFields()) {
                this.createAliasIfNecessary(pesquisa, field);
            }
        }
        return pesquisa;
    }

    public boolean hasMultitenancy() {
        return this.entityInformation.getJavaType().isAnnotationPresent(GumgaMultitenancy.class);
    }

    public boolean hasLogicalDelete() {
        return GumgaLDModel.class.isAssignableFrom(this.entityInformation.getJavaType());
    }

    public String getMultitenancyPattern() {
        GumgaMultitenancy tenacy = this.entityInformation.getJavaType().getAnnotation(GumgaMultitenancy.class);
        return GumgaMultitenancyUtil.getMultitenancyPattern((GumgaMultitenancy)tenacy);
    }

    private void createAliasIfNecessary(Pesquisa<T> pesquisa, String field) {
        String[] chain = field.split("\\.");
        if (chain.length <= 1) {
            return;
        }
        if (pesquisa.getAliases().contains(chain[0])) {
            return;
        }
        pesquisa.createAlias(chain[0], chain[0]);
        pesquisa.addAlias(chain[0]);
    }

    public Pesquisa<T> search() {
        return Pesquisa.createCriteria((Session)this.session(), (Class)this.entityInformation.getJavaType());
    }

    public T findOne(ID id) {
        Object resource;
        if (GumgaSharedModel.class.isAssignableFrom(this.entityInformation.getJavaType()) || GumgaSharedModelUUID.class.isAssignableFrom(this.entityInformation.getJavaType())) {
            QueryObject qo = new QueryObject();
            if (GumgaSharedModelUUID.class.isAssignableFrom(this.entityInformation.getJavaType())) {
                qo.setAq("obj.id='" + id + "'");
            } else {
                qo.setAq("obj.id=" + id);
            }
            SearchResult<T> search = this.search(qo);
            if (search.getCount() == 1L) {
                return (T)search.getValues().get(0);
            }
            if (!((Boolean)GumgaThreadScope.ignoreCheckOwnership.get()).booleanValue()) {
                throw new EntityNotFoundException("cannot find " + this.entityInformation.getJavaType() + " with id: " + id);
            }
        }
        if ((resource = super.findOne(id)) == null) {
            throw new EntityNotFoundException("cannot find " + this.entityInformation.getJavaType() + " with id: " + id);
        }
        this.checkOwnership(resource);
        return (T)resource;
    }

    public Object genericFindOne(Class clazz, Object id) {
        Object result = this.entityManager.find(clazz, id);
        if (result == null) {
            throw new EntityNotFoundException("cannot find " + clazz.getName() + " with id: " + id);
        }
        this.checkOwnership(result);
        return result;
    }

    private Session session() {
        return (Session)this.entityManager.unwrap(Session.class);
    }

    private SearchResult<T> advancedSearch(QueryObject query) {
        String hqlConsulta;
        if (GumgaQueryParserProvider.defaultMap.equals(GumgaQueryParserProvider.getMySqlLikeMap()) || GumgaQueryParserProvider.defaultMap.equals(GumgaQueryParserProvider.getH2LikeMap())) {
            query.setAq(query.getAq().replaceAll("to_timestamp\\(", "").replaceAll(",'yyyy/MM/dd HH24:mi:ss'\\)", ""));
        }
        String modelo = "from %s obj WHERE %s";
        if (this.hasMultitenancy()) {
            String ld = "";
            if (this.hasLogicalDelete()) {
                ld = " obj.gumgaActive=" + !query.isInactiveSearch() + " and ";
            }
            GumgaMultitenancy gumgaMultiTenancy = this.getDomainClass().getAnnotation(GumgaMultitenancy.class);
            String oiPattern = GumgaMultitenancyUtil.getMultitenancyPattern((GumgaMultitenancy)gumgaMultiTenancy);
            String sharedCriterion = " ";
            if (GumgaSharedModel.class.isAssignableFrom(this.entityInformation.getJavaType()) || GumgaSharedModelUUID.class.isAssignableFrom(this.entityInformation.getJavaType())) {
                String instanceOi = (String)GumgaThreadScope.instanceOi.get() + "GLOBAL.";
                sharedCriterion = "or (obj.gumgaOrganizations like '%%," + oiPattern + ",%%' or obj.gumgaOrganizations like '%%," + instanceOi + ",%%' or obj.gumgaUsers like '%%," + (String)GumgaThreadScope.login.get() + ",%%') ";
            }
            modelo = gumgaMultiTenancy.allowPublics() ? (gumgaMultiTenancy.publicMarking() == TenancyPublicMarking.NULL ? "from %s obj WHERE (" + ld + "obj.oi is null OR obj.oi like '" + oiPattern + "%%' " + sharedCriterion + ")  AND (%s) " : "from %s obj WHERE (" + ld + "obj.oi = '" + gumgaMultiTenancy.publicMarking().getMark() + "' OR obj.oi like '" + oiPattern + "%%' " + sharedCriterion + ")  AND (%s) ") : "from %s obj WHERE (" + ld + "obj.oi like '" + oiPattern + "%%' " + sharedCriterion + ")  AND (%s) ";
        }
        if (query.getSortField().isEmpty()) {
            hqlConsulta = String.format(modelo + " ORDER BY obj.id ", this.entityInformation.getEntityName(), query.getAq());
        } else {
            String orderField = this.getOrderField(query.getSortField(), query.getSortDir());
            hqlConsulta = String.format(modelo + " ORDER BY %s", this.entityInformation.getEntityName(), query.getAq(), orderField);
        }
        Long total = 0L;
        if (query.isSearchCount()) {
            String hqlConta = String.format("SELECT count(obj) " + modelo, this.entityInformation.getEntityName(), query.getAq());
            Query qConta = this.entityManager.createQuery(hqlConta);
            total = (Long)qConta.getSingleResult();
        }
        Query qConsulta = this.entityManager.createQuery(hqlConsulta);
        qConsulta.setMaxResults(query.getPageSize());
        qConsulta.setFirstResult(query.getStart());
        List resultList = query.isCountOnly() ? Collections.emptyList() : qConsulta.getResultList();
        return new SearchResult(query, (Number)total, resultList);
    }

    public <A> SearchResult<A> advancedSearch(String selectQueryWithoutWhere, String countQuery, String ordenationId, QueryObject whereQuery) {
        if (Strings.isNullOrEmpty((String)ordenationId)) {
            throw new IllegalArgumentException("Para realizar a search deve se informar um OrdenationId para complementar a ordena\u00e7\u00e3o");
        }
        String modelo = selectQueryWithoutWhere + " WHERE %s";
        String hqlConsulta = whereQuery.getSortField().isEmpty() ? String.format(modelo, whereQuery.getAq()) : String.format(modelo + " ORDER BY %s %s, %s", whereQuery.getAq(), whereQuery.getSortField(), whereQuery.getSortDir(), ordenationId);
        String hqlConta = countQuery + " WHERE " + whereQuery.getAq();
        Query qConta = this.entityManager.createQuery(hqlConta);
        Query qConsulta = this.entityManager.createQuery(hqlConsulta);
        Long total = (Long)qConta.getSingleResult();
        qConsulta.setMaxResults(whereQuery.getPageSize());
        qConsulta.setFirstResult(whereQuery.getStart());
        List resultList = qConsulta.getResultList();
        return new SearchResult(whereQuery, (Number)total, resultList);
    }

    public SearchResult<T> search(String hql, Map<String, Object> params) {
        Query query = this.entityManager.createQuery(hql);
        if (params != null) {
            for (String key : params.keySet()) {
                query.setParameter(key, params.get(key));
            }
        }
        List result = query.getResultList();
        int total = result.size();
        return new SearchResult(0, total, (Number)total, result);
    }

    public SearchResult<T> search(String hql, Map<String, Object> params, int max, int first) {
        Query query = this.entityManager.createQuery(hql);
        if (params != null) {
            for (String key : params.keySet()) {
                query.setParameter(key, params.get(key));
            }
        }
        query.setMaxResults(max);
        query.setFirstResult(first);
        List result = query.getResultList();
        int total = result.size();
        return new SearchResult(0, total, (Number)total, result);
    }

    protected TypedQuery<Long> getCountQuery(Specification<T> spec) {
        return super.getCountQuery(spec);
    }

    protected TypedQuery<T> getQuery(Specification<T> spec, Sort sort) {
        return super.getQuery(spec, sort);
    }

    protected TypedQuery<T> getQuery(Specification<T> spec, Pageable pageable) {
        return super.getQuery(spec, pageable);
    }

    protected Page<T> readPage(TypedQuery<T> query, Pageable pageable, Specification<T> spec) {
        return super.readPage(query, pageable, spec);
    }

    public void flush() {
        super.flush();
    }

    public <S extends T> List<S> save(Iterable<S> entities) {
        return super.save(entities);
    }

    public <S extends T> S saveAndFlush(S entity) {
        return (S)super.saveAndFlush(entity);
    }

    public <S extends T> S save(S entity) {
        return (S)super.save(entity);
    }

    public long count(Specification<T> spec) {
        return super.count(spec);
    }

    public long count() {
        return super.count();
    }

    public List<T> findAll(Specification<T> spec, Sort sort) {
        if (this.hasMultitenancy()) {
            throw new GumgaGenericRepositoryException(this.noMultiTenancyMessage());
        }
        return super.findAll(spec, sort);
    }

    public Page<T> findAll(Specification<T> spec, Pageable pageable) {
        if (this.hasMultitenancy()) {
            throw new GumgaGenericRepositoryException(this.noMultiTenancyMessage());
        }
        return super.findAll(spec, pageable);
    }

    public List<T> findAll(Specification<T> spec) {
        if (this.hasMultitenancy()) {
            throw new GumgaGenericRepositoryException(this.noMultiTenancyMessage());
        }
        return super.findAll(spec);
    }

    public T findOne(Specification<T> spec) {
        if (this.hasMultitenancy()) {
            throw new GumgaGenericRepositoryException(this.noMultiTenancyMessage());
        }
        return (T)super.findOne(spec);
    }

    public Page<T> findAll(Pageable pageable) {
        if (this.hasMultitenancy()) {
            throw new GumgaGenericRepositoryException(this.noMultiTenancyMessage());
        }
        return super.findAll(pageable);
    }

    public List<T> findAll(Sort sort) {
        if (this.hasMultitenancy()) {
            throw new GumgaGenericRepositoryException(this.noMultiTenancyMessage());
        }
        return super.findAll(sort);
    }

    public List<T> findAll(Iterable<ID> ids) {
        if (ids == null || !ids.iterator().hasNext()) {
            return Collections.emptyList();
        }
        ArrayList<T> toReturn = new ArrayList<T>();
        for (Serializable id : ids) {
            T found = this.findOne(id);
            if (found == null) continue;
            toReturn.add(found);
        }
        return toReturn;
    }

    public List<T> findAll() {
        if (this.hasMultitenancy()) {
            return this.findAll(new GQuery());
        }
        return super.findAll();
    }

    public boolean exists(ID id) {
        return super.exists(id);
    }

    public T getOne(ID id) {
        Object objectFind = super.getOne(id);
        this.checkOwnership(objectFind);
        return (T)objectFind;
    }

    public void deleteAllInBatch() {
        if (this.hasMultitenancy()) {
            log.error("NOMULTITENACYIMPL -> " + this.noMultiTenancyMessage());
        }
        super.deleteAllInBatch();
    }

    public void deleteAll() {
        if (this.hasMultitenancy()) {
            for (Object entity : this.findAll()) {
                this.delete((ID)entity);
            }
        } else {
            super.deleteAll();
        }
    }

    public void deleteInBatch(Iterable<T> entities) {
        if (this.hasMultitenancy()) {
            this.delete((ID)entities);
        }
        super.deleteInBatch(entities);
    }

    public void delete(Iterable<? extends T> entities) {
        if (this.hasMultitenancy()) {
            for (T entity : entities) {
                this.delete((ID)entity);
            }
        }
        super.delete(entities);
    }

    public void delete(T entity) {
        if (this.hasMultitenancy()) {
            this.checkOwnership(entity);
            if (entity instanceof GumgaLDModel) {
                ((GumgaLDModel)entity).setGumgaActive(Boolean.FALSE);
                return;
            }
        }
        super.delete(entity);
    }

    public void delete(ID id) {
        if (this.hasMultitenancy()) {
            this.checkOwnership(this.findOne(id));
        }
        super.delete(id);
    }

    protected Class<T> getDomainClass() {
        return super.getDomainClass();
    }

    public void setRepositoryMethodMetadata(CrudMethodMetadata crudMethodMetadata) {
        super.setRepositoryMethodMetadata(crudMethodMetadata);
    }

    public List<GumgaObjectAndRevision> listOldVersions(ID id) {
        ArrayList<GumgaObjectAndRevision> aRetornar = new ArrayList<GumgaObjectAndRevision>();
        AuditReader ar = AuditReaderFactory.get((EntityManager)this.entityManager);
        List revisoes = ar.getRevisions(this.entityInformation.getJavaType(), id);
        for (Number n : revisoes) {
            GumgaRevisionEntity gumgaRevisionEntity = (GumgaRevisionEntity)this.entityManager.find(GumgaRevisionEntity.class, (Object)n.longValue());
            Object object = ar.find(this.entityInformation.getJavaType(), id, (Number)n.longValue());
            aRetornar.add(new GumgaObjectAndRevision(gumgaRevisionEntity, object));
        }
        return aRetornar;
    }

    private void checkOwnership(Object o) throws EntityNotFoundException {
        if (GumgaThreadScope.ignoreCheckOwnership.get() != null && ((Boolean)GumgaThreadScope.ignoreCheckOwnership.get()).booleanValue()) {
            return;
        }
        if (!o.getClass().isAnnotationPresent(GumgaMultitenancy.class)) {
            return;
        }
        if (GumgaThreadScope.organizationCode.get() == null) {
            return;
        }
        if (o instanceof GumgaModel) {
            this.gumgaModel((GumgaModel)o);
        } else if (o instanceof GumgaModelUUID) {
            this.gumgaModelUUID((GumgaModelUUID)o);
        } else {
            this.gumgaModelSharedUUID((GumgaSharedModelUUID)o);
        }
    }

    private void gumgaModel(GumgaModel object) {
        if (this.hasMultitenancy() && object.getOi() != null && (GumgaThreadScope.organizationCode.get() == null || !object.getOi().getValue().startsWith(this.getMultitenancyPattern()))) {
            throw new EntityNotFoundException("cannot find object of " + this.entityInformation.getJavaType() + " with id: " + object.getId() + " in your organization: " + (String)GumgaThreadScope.organizationCode.get());
        }
    }

    private void gumgaModelSharedUUID(GumgaSharedModelUUID object) {
        if (this.hasMultitenancy() && object.getOi() != null && (GumgaThreadScope.organizationCode.get() == null || !object.getOi().getValue().startsWith(this.getMultitenancyPattern()))) {
            throw new EntityNotFoundException("cannot find object of " + this.entityInformation.getJavaType() + " with id: " + object.getId() + " in your organization: " + (String)GumgaThreadScope.organizationCode.get());
        }
    }

    private void gumgaModelUUID(GumgaModelUUID object) {
        if (this.hasMultitenancy() && object.getOi() != null && (GumgaThreadScope.organizationCode.get() == null || !object.getOi().getValue().startsWith(this.getMultitenancyPattern()))) {
            throw new EntityNotFoundException("cannot find object of " + this.entityInformation.getJavaType() + " with id: " + object.getId() + " in your organization: " + (String)GumgaThreadScope.organizationCode.get());
        }
    }

    private String noMultiTenancyMessage() {
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        String msg = stackTrace.length >= 4 ? "The method '" + stackTrace[2].getMethodName() + "' in line " + stackTrace[2].getLineNumber() + " of class '" + stackTrace[2].getClassName() + "' called from method '" + stackTrace[3].getMethodName() + "' of class '" + stackTrace[3].getClassName() + "' has no implementation for MultiTenancy yet. Ask Gumga." : "No implementation for MultiTenancy yet. Ask Gumga.";
        return msg;
    }

    public SearchResult<T> findAllWithTenancy() {
        QueryObject qo = new QueryObject();
        qo.setPageSize(0x7FFFFFFE);
        return this.search(qo);
    }

    private String getWhereMultiTenancy() {
        String tenant = " where ";
        if (this.hasMultitenancy() && GumgaThreadScope.organizationCode.get() != null && (GumgaThreadScope.ignoreCheckOwnership.get() == null || !((Boolean)GumgaThreadScope.ignoreCheckOwnership.get()).booleanValue())) {
            String oiPattern = GumgaMultitenancyUtil.getMultitenancyPattern((GumgaMultitenancy)this.entityInformation.getJavaType().getAnnotation(GumgaMultitenancy.class));
            String oi = "obj.oi is null or obj.oi like '" + oiPattern + "%'";
            if (GumgaSharedModel.class.isAssignableFrom(this.entityInformation.getJavaType()) || GumgaSharedModelUUID.class.isAssignableFrom(this.entityInformation.getJavaType())) {
                String instanceOi = (String)GumgaThreadScope.instanceOi.get() + "GLOBAL.";
                tenant = tenant.concat("(".concat(oi)).concat(" or obj.gumgaOrganizations like '%," + oiPattern + ",%' or obj.gumgaOrganizations like '%," + instanceOi + ",%' or obj.gumgaUsers like '%," + (String)GumgaThreadScope.login.get() + ",%') ");
            } else {
                tenant = tenant.concat("(").concat(oi).concat(")");
            }
        } else {
            tenant = tenant.concat(" 1=1");
        }
        return tenant;
    }

    public SearchResult<T> findByGQuery(QueryObject queryObject) {
        if (queryObject.getgQuery() == null) {
            queryObject.setgQuery(new GQuery());
        }
        GQuery gQuery = queryObject.getgQuery();
        Long total = 0L;
        if (queryObject.isSearchCount()) {
            Query queryCountWithGQuery = this.createQueryCountWithGQuery(gQuery);
            total = (Long)queryCountWithGQuery.getSingleResult();
        }
        Query queryWithGQuery = this.createQueryGQueryWithQueryObject(queryObject);
        queryWithGQuery.setMaxResults(queryObject.getPageSize());
        queryWithGQuery.setFirstResult(queryObject.getStart());
        return new SearchResult(queryObject, (Number)total, queryWithGQuery.getResultList());
    }

    public T fetchOne(GQuery gQuery) {
        Query search = this.createQueryWithGQuery(gQuery);
        try {
            List resultList = search.getResultList();
            return resultList.isEmpty() ? null : (T)resultList.get(0);
        }
        catch (Exception e) {
            return null;
        }
    }

    public List<T> findAll(GQuery gQuery) {
        Query search = this.createQueryWithGQuery(gQuery);
        search.setMaxResults(Integer.MAX_VALUE);
        List resultList = search.getResultList();
        return resultList;
    }

    private Query createQueryGQueryWithQueryObject(QueryObject queryObject) {
        if (queryObject.getgQuery() == null) {
            queryObject.setgQuery(new GQuery());
        }
        GQuery gQuery = queryObject.getgQuery();
        String sort = this.getOrderField(queryObject.getSortField(), queryObject.getSortDir());
        Boolean useDistinct = gQuery.useDistinct();
        String query = (useDistinct != false ? "select distinct" : "select") + " obj FROM ".concat(this.entityInformation.getEntityName()).concat(" obj");
        String where = this.createWhere(gQuery);
        return this.entityManager.createQuery(query.concat(gQuery.getJoins()).concat(where).concat(" order by ").concat(sort));
    }

    private void getOrderField(Pesquisa<T> pesquisa, String sortField, String sorDir) {
        String orderColumns = sortField;
        String orderType = sorDir;
        String[] columns = null;
        columns = orderColumns.indexOf(",") > 0 ? orderColumns.split(",") : new String[]{orderColumns};
        String[] types = null;
        types = orderType.indexOf(",") > 0 ? orderType.split(",") : new String[]{orderType};
        Boolean existsID = Boolean.FALSE;
        for (int i = 0; i < columns.length; ++i) {
            pesquisa.addOrder(i < types.length && !types[i].trim().isEmpty() && types[i].trim().equalsIgnoreCase("desc") ? Order.desc((String)columns[i]) : Order.asc((String)columns[i]));
            if (!columns[i].trim().equalsIgnoreCase("id")) continue;
            existsID = Boolean.TRUE;
        }
        if (!existsID.booleanValue()) {
            pesquisa.addOrder(Order.asc((String)"id"));
        }
    }

    private String getOrderField(String sortField, String sorDir) {
        if (sortField != null && sorDir != null && !sortField.trim().isEmpty()) {
            String orderColumns = sortField;
            String orderType = sorDir;
            String[] columns = null;
            columns = orderColumns.indexOf(",") > 0 ? orderColumns.split(",") : new String[]{orderColumns};
            String[] types = null;
            types = orderType.indexOf(",") > 0 ? orderType.split(",") : new String[]{orderType};
            String ordem = "";
            Boolean existsID = Boolean.FALSE;
            for (int i = 0; i < columns.length; ++i) {
                ordem = ordem.concat(columns[i]).concat(i < types.length ? " ".concat(types[i].trim().isEmpty() ? "asc" : types[i]) : " asc").concat(",");
                if (!columns[i].trim().equalsIgnoreCase("id") && !columns[i].trim().equalsIgnoreCase("obj.id")) continue;
                existsID = Boolean.TRUE;
            }
            if (!existsID.booleanValue()) {
                ordem = ordem.concat("obj.id asc,");
            }
            return ordem.substring(0, ordem.length() - 1);
        }
        return "obj.id asc";
    }

    private Query createQueryWithGQuery(GQuery gQuery) {
        Boolean useDistinct = gQuery.useDistinct();
        String query = (useDistinct != false ? "select distinct" : "select") + " obj FROM ".concat(this.entityInformation.getEntityName()).concat(" obj");
        String where = this.createWhere(gQuery);
        return this.entityManager.createQuery(query.concat(gQuery.getJoins()).concat(where));
    }

    private Query createQueryCountWithGQuery(GQuery gQuery) {
        Boolean useDistinct = gQuery.useDistinct();
        String query = (useDistinct != false ? "select distinct" : "select") + " count(obj) FROM ".concat(this.entityInformation.getEntityName()).concat(" obj");
        String where = this.createWhere(gQuery);
        CriteriaBuilder criteriaBuilder = this.entityManager.getCriteriaBuilder();
        return this.entityManager.createQuery(query.concat(gQuery.getJoins()).concat(where));
    }

    private String createWhere(GQuery gQuery) {
        String gQueryWhere = gQuery.toString();
        if (GumgaQueryParserProvider.defaultMap.equals(GumgaQueryParserProvider.getMySqlLikeMap())) {
            gQueryWhere = this.removeFunctionToTimestamp(gQueryWhere).replaceAll("translate\\(", "").replaceAll(", '\u00e2\u00e0\u00e3\u00e1\u00c1\u00c2\u00c0\u00c3\u00e9\u00ea\u00c9\u00ca\u00ed\u00cd\u00f3\u00f4\u00f5\u00d3\u00d4\u00d5\u00fc\u00fa\u00dc\u00da\u00c7\u00e7','AAAAAAAAEEEEIIOOOOOOUUUUCC'\\)", "");
        } else if (GumgaQueryParserProvider.defaultMap.equals(GumgaQueryParserProvider.getH2LikeMap())) {
            gQueryWhere = this.removeFunctionToTimestamp(gQueryWhere);
        }
        return this.getWhereMultiTenancy().concat(StringUtils.isEmpty((Object)gQueryWhere) ? "" : " and ".concat(gQueryWhere));
    }

    private String removeFunctionToTimestamp(String gQueryWhere) {
        gQueryWhere = gQueryWhere.replaceAll("to_timestamp\\(", "").replaceAll(",'yyyy/MM/dd HH24:mi:ss'\\)", "");
        return gQueryWhere;
    }
}

