/*
 * Decompiled with CFR 0.152.
 */
package io.gumga.application.spring.config;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.hibernate.cfg.NamingStrategy;
import org.hibernate.internal.util.StringHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GumgaNamingStrategy
implements NamingStrategy,
Serializable {
    private static final Logger log = LoggerFactory.getLogger(GumgaNamingStrategy.class);
    public static final String[] RESERVED_WORDS = new String[]{"ACCESS", "ADD", "ALL", "ALTER", "AND", "ANY", "AS", "ASC", "AUDIT", "BETWEEN", "BY", "CHAR", "CHECK", "CLUSTER", "COLUMN", "COMMENT", "COMPRESS", "CONNECT", "CREATE", "CURRENT", "DATE", "DECIMAL", "DEFAULT", "DELETE", "DESC", "DISTINCT", "DROP", "ELSE", "EXCLUSIVE", "EXISTS", "FILE", "FLOAT", "FOR", "FROM", "GRANT", "GROUP", "HAVING", "IDENTIFIED", "IMMEDIATE", "IN", "INCREMENT", "INDEX", "INITIAL", "INSERT", "INTEGER", "INTERSECT", "INTO", "IS", "LEVEL", "LIKE", "LOCK", "LONG", "MAXEXTENTS", "MINUS", "MLSLABEL", "MODE", "MODIFY", "NOAUDIT", "NOCOMPRESS", "NOT", "NOWAIT", "NULL", "NUMBER", "OF", "OFFLINE", "ON", "ONLINE", "OPTION", "OR", "ORDER", "PCTFREE", "PRIOR", "PRIVILEGES", "PUBLIC", "RAW", "RENAME", "RESOURCE", "REVOKE", "ROW", "ROWID", "ROWNUM", "ROWS", "SELECT", "SESSION", "SET", "SHARE", "SIZE", "SMALLINT", "START", "SUCCESSFUL", "SYNONYM", "SYSDATE", "TABLE", "THEN", "TO", "TRIGGER", "UID", "UNION", "UNIQUE", "UPDATE", "USER", "VALIDATE", "VALUES", "VARCHAR", "VARCHAR2", "VIEW", "WHENEVER", "WHERE", "WITH", "KEY", "PASSWORD"};
    public static final int ORACLE_MAX_SIZE = 30;
    private final List<String> reservedWords;

    public GumgaNamingStrategy() {
        log.warn("-----------------GumgaNamingStrategy BETA -----------------------------");
        this.reservedWords = Arrays.asList(RESERVED_WORDS);
    }

    public String classToTableName(String string) {
        String table = StringHelper.unqualify((String)string);
        return this.oracleSafe(table).toUpperCase();
    }

    public String collectionTableName(String ownerEntity, String ownerEntityTable, String associatedEntity, String associatedEntityTable, String propertyName) {
        return this.tableName(ownerEntityTable + "_" + (associatedEntityTable != null ? associatedEntityTable : StringHelper.unqualify((String)propertyName)));
    }

    public String columnName(String string) {
        return this.oracleSafe(string);
    }

    public String foreignKeyColumnName(String propertyName, String propertyEntityName, String propertyTableName, String referencedColumnName) {
        String header = propertyName != null ? StringHelper.unqualify((String)propertyName) : propertyTableName;
        Objects.requireNonNull(header, "GumgaNamingStrategy not properly filled on foreignKeyColumnName");
        return this.columnName(header + "_" + referencedColumnName);
    }

    public String joinKeyColumnName(String joinedColumn, String joinedTable) {
        return this.columnName(joinedColumn);
    }

    public String logicalCollectionColumnName(String columnName, String propertyName, String referencedColumn) {
        return this.oracleSafe(StringHelper.isNotEmpty((String)columnName) ? columnName : StringHelper.unqualify((String)propertyName) + "_" + referencedColumn);
    }

    public String logicalCollectionTableName(String tableName, String ownerEntityTable, String associatedEntityTable, String propertyName) {
        if (tableName != null) {
            return this.oracleSafe(tableName);
        }
        return this.oracleSafe(new StringBuffer(ownerEntityTable).append("_").append(associatedEntityTable != null ? associatedEntityTable : StringHelper.unqualify((String)propertyName)).toString());
    }

    public String logicalColumnName(String columnName, String propertyName) {
        return this.oracleSafe(StringHelper.isNotEmpty((String)columnName) ? columnName : StringHelper.unqualify((String)propertyName));
    }

    public String propertyToColumnName(String propertyName) {
        return this.oracleSafe(StringHelper.unqualify((String)propertyName));
    }

    public String tableName(String string) {
        return this.oracleSafe(string);
    }

    private String oracleSafe(String name) {
        boolean loga = false;
        String originalName = name;
        if (name.length() >= 30) {
            loga = true;
            String initials = "";
            int lastPos = 0;
            int i = 0;
            for (char c : name.toCharArray()) {
                if (!Character.isUpperCase(c) && ++i != 1) continue;
                initials = initials + c;
                lastPos = i;
            }
            name = initials = initials + name.substring(lastPos);
        }
        if (this.reservedWords.contains(name = name.toUpperCase())) {
            loga = true;
            name = "G_" + name;
        }
        if (name.length() >= 30) {
            loga = true;
        }
        name = name.substring(0, name.length() >= 30 ? 30 : name.length());
        if (loga) {
            log.warn("--- GumgaNamingStrategy -->" + originalName + "=>" + name);
        }
        return name;
    }
}

