/*
 * Decompiled with CFR 0.152.
 */
package io.gumga.application.service;

import io.gumga.core.service.GumgaPasswordService;
import org.jasypt.digest.StandardStringDigester;
import org.springframework.stereotype.Service;

@Service(value="gumgaPasswordService")
public class JasyptGumgaPasswordService
implements GumgaPasswordService {
    private static StandardStringDigester encryptor;

    public JasyptGumgaPasswordService() {
        encryptor = new StandardStringDigester();
        encryptor.setAlgorithm("SHA-1");
        encryptor.setIterations(10000);
    }

    public String encryptPassword(String rawPassword) {
        return encryptor.digest(rawPassword);
    }

    public Boolean isPasswordCorrect(String informedPassword, String encryptedPassword) {
        return encryptor.matches(informedPassword, encryptedPassword);
    }
}

