/*
 * Decompiled with CFR 0.152.
 */
package io.gumga.application.service;

import io.gumga.application.customfields.GumgaCustomEnhancerService;
import io.gumga.core.exception.NoMultiTenancyException;
import io.gumga.core.utils.ReflectionUtils;
import io.gumga.domain.GumgaMultitenancy;
import io.gumga.domain.customfields.GumgaCustomizableModel;
import io.gumga.domain.domains.GumgaOi;
import io.gumga.domain.repository.GumgaCrudRepository;
import io.gumga.domain.repository.GumgaMultitenancyUtil;
import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractGumgaService<T, ID extends Serializable> {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected final GumgaCrudRepository<T, ID> repository;
    @Autowired
    protected GumgaCustomEnhancerService gces;

    public AbstractGumgaService(GumgaCrudRepository<T, ID> repository) {
        this.repository = repository;
    }

    public Class<T> clazz() {
        return ReflectionUtils.inferGenericType(this.getClass());
    }

    public void loadGumgaCustomFields(Object entity) {
        if (entity instanceof GumgaCustomizableModel) {
            this.gces.loadCustomFields(entity);
        }
    }

    public GumgaOi gumgaOiForSearch() {
        try {
            String oiPattern = GumgaMultitenancyUtil.getMultitenancyPattern((GumgaMultitenancy)this.clazz().getAnnotation(GumgaMultitenancy.class));
            GumgaOi oi = new GumgaOi(oiPattern);
            return oi;
        }
        catch (Exception ex) {
            throw new NoMultiTenancyException("The class " + this.clazz().getCanonicalName() + " haven't MultiTenancy");
        }
    }

    public GumgaOi gumgaOiForSearchWithWildCard() {
        try {
            String oiPattern = GumgaMultitenancyUtil.getMultitenancyPattern((GumgaMultitenancy)this.clazz().getAnnotation(GumgaMultitenancy.class));
            GumgaOi oi = new GumgaOi(oiPattern.concat("%"));
            return oi;
        }
        catch (Exception ex) {
            throw new NoMultiTenancyException("The class " + this.clazz().getCanonicalName() + " haven't MultiTenancy");
        }
    }
}

