/*
 * Decompiled with CFR 0.152.
 */
package io.gumga.application.nlp;

import io.gumga.core.GumgaValues;
import io.gumga.domain.nlp.GumgaNLPThing;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.cogroo.analyzer.Analyzer;
import org.cogroo.analyzer.ComponentFactory;
import org.cogroo.text.Chunk;
import org.cogroo.text.Document;
import org.cogroo.text.Sentence;
import org.cogroo.text.SyntacticChunk;
import org.cogroo.text.Token;
import org.cogroo.text.impl.DocumentImpl;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class GumgaNLP {
    public static final String NO_GUMGANLP = "NO_GUMGANLP";
    public static final String NO_NAME = "_NO_NAME";
    private Analyzer cogroo;
    private Reflections reflections;
    private Set<Class<?>> classOfInterest;
    private static final Logger log = LoggerFactory.getLogger(GumgaNLP.class);

    @Autowired
    public GumgaNLP(GumgaValues gumgaValues) {
        String basePackage = gumgaValues.getGumgaNLPBasePackage();
        if (NO_GUMGANLP.equalsIgnoreCase(basePackage)) {
            log.warn("GumgaNLP ------ DISABLED");
            return;
        }
        try {
            ComponentFactory factory = ComponentFactory.create((Locale)new Locale("pt", "BR"));
            this.cogroo = factory.createPipe();
            this.reflections = new Reflections(basePackage, new Scanner[0]);
            log.info("ReflectionsConfiguration------->" + this.reflections.getConfiguration().getUrls());
            this.classOfInterest = this.reflections.getTypesAnnotatedWith(GumgaNLPThing.class);
            log.warn("GumgaNLP ------" + basePackage + "----->" + this.classOfInterest);
        }
        catch (Exception ex) {
            log.error("GumgaNLP ------" + basePackage + "-----> NOT WORKING IN THIS SYSTEM " + ex);
        }
    }

    public List<Object> createObjectsFromDocument(String text, String instanceVerbs) throws Exception {
        List<String> verbs = Arrays.asList(instanceVerbs.split(","));
        DocumentImpl document = new DocumentImpl();
        document.setText(text);
        this.cogroo.analyze((Document)document);
        this.print((Document)document);
        ArrayList<Object> toReturn = new ArrayList<Object>();
        Object currentObject = null;
        Field currentField = null;
        Estados estado = Estados.VERBO;
        for (Sentence sentence : document.getSentences()) {
            List tokens = sentence.getTokens();
            for (int i = 0; i < tokens.size(); ++i) {
                Token token = (Token)sentence.getTokens().get(i);
                if (token.getPOSTag().startsWith("v-")) {
                    for (String v : verbs) {
                        if (!Arrays.asList(token.getLemmas()).contains(v)) continue;
                        estado = Estados.SUBSTANTIVO;
                    }
                    continue;
                }
                if (estado == Estados.SUBSTANTIVO && token.getPOSTag().startsWith("n")) {
                    Object classe = null;
                    for (Class<?> c : this.classOfInterest) {
                        GumgaNLPThing gumgaNPLThing = c.getAnnotation(GumgaNLPThing.class);
                        String nome = (NO_NAME.equals(gumgaNPLThing.value()) ? c.getSimpleName() : gumgaNPLThing.value()).toLowerCase();
                        if (!nome.equals(token.getLexeme())) continue;
                        currentObject = c.newInstance();
                        toReturn.add(currentObject);
                        estado = Estados.ATRIBUTOS;
                    }
                    continue;
                }
                if (estado == Estados.ATRIBUTOS && token.getPOSTag().startsWith("n")) {
                    try {
                        currentField = this.mapAllFields(currentObject.getClass()).get(token.getLexeme());
                        estado = Estados.VALOR_ATRIBUTO;
                    }
                    catch (NullPointerException classe) {}
                    continue;
                }
                if (estado != Estados.VALOR_ATRIBUTO || token.getPOSTag().startsWith("prp")) continue;
                try {
                    currentField.setAccessible(true);
                    currentField.set(currentObject, currentField.getType().getConstructor(String.class).newInstance(token.getLexeme().toLowerCase()));
                    estado = Estados.ATRIBUTOS;
                    continue;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        return toReturn;
    }

    private Map<String, Field> mapAllFields(Class clazz) {
        Field[] declaredFields;
        Map<Object, Object> toReturn = clazz.getSuperclass().equals(Object.class) ? new HashMap() : this.mapAllFields(clazz.getSuperclass());
        for (Field f : declaredFields = clazz.getDeclaredFields()) {
            String label = f.getName();
            if (f.isAnnotationPresent(GumgaNLPThing.class)) {
                GumgaNLPThing annotation = f.getAnnotation(GumgaNLPThing.class);
                label = annotation.value();
            }
            toReturn.put(label, f);
        }
        return toReturn;
    }

    private void print(Document document) {
        StringBuilder output = new StringBuilder();
        for (Sentence sentence : document.getSentences()) {
            output.append("Sentence: ").append(sentence.getText()).append("\n");
            output.append("  Tokens: \n");
            for (Token token : sentence.getTokens()) {
                String lexeme = token.getLexeme();
                String lemmas = Arrays.toString(token.getLemmas());
                String pos = token.getPOSTag();
                String feat = token.getFeatures();
                output.append(String.format("    %-10s %-12s %-6s %-10s\n", lexeme, lemmas, pos, feat));
            }
            output.append("  Chunks: ");
            for (Chunk chunk : sentence.getChunks()) {
                output.append("[").append(chunk.getTag()).append(": ");
                for (Token innerToken : chunk.getTokens()) {
                    output.append(innerToken.getLexeme()).append(" ");
                }
                output.append("] ");
            }
            output.append("\n");
            output.append("  Shallow Structure: ");
            for (SyntacticChunk structure : sentence.getSyntacticChunks()) {
                output.append("[").append(structure.getTag()).append(": ");
                for (Token innerToken : structure.getTokens()) {
                    output.append(innerToken.getLexeme()).append(" ");
                }
                output.append("] ");
            }
            output.append("\n");
        }
        System.out.println(output.toString());
    }

    private static enum Estados {
        VERBO,
        SUBSTANTIVO,
        FIM,
        ATRIBUTOS,
        VALOR_ATRIBUTO;

    }
}

