/*
 * Decompiled with CFR 0.152.
 */
package io.gumga.application;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.persistence.Entity;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.lucene.search.Query;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.metadata.ClassMetadata;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.jpa.FullTextEntityManager;
import org.hibernate.search.jpa.Search;
import org.hibernate.search.query.dsl.QueryBuilder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class GumgaUntypedRepository {
    @PersistenceContext
    private EntityManager em;

    @Transactional
    public void save(Object obj) {
        this.em.persist(obj);
    }

    public List<Object> fullTextSearchaaa(String text, Class entidade, String ... atributos) {
        FullTextEntityManager fullTextEntityManager = Search.getFullTextEntityManager((EntityManager)this.em);
        QueryBuilder qb = fullTextEntityManager.getSearchFactory().buildQueryBuilder().forEntity(entidade).get();
        Query query = qb.keyword().onFields(atributos).matching((Object)text).createQuery();
        return fullTextEntityManager.createFullTextQuery(query, new Class[]{entidade}).getResultList();
    }

    public List<Object> fullTextSearch(String text) {
        ArrayList<Object> aRetornar = new ArrayList<Object>();
        for (Class entidade : this.getAllIndexedEntities()) {
            FullTextEntityManager fullTextEntityManager = Search.getFullTextEntityManager((EntityManager)this.em);
            QueryBuilder qb = fullTextEntityManager.getSearchFactory().buildQueryBuilder().forEntity(entidade).get();
            String atributos = "";
            List<Field> todosAtributos = GumgaUntypedRepository.getTodosAtributos(entidade);
            for (Field f : todosAtributos) {
                if (!f.isAnnotationPresent(org.hibernate.search.annotations.Field.class)) continue;
                atributos = atributos + f.getName() + ",";
            }
            if (atributos.isEmpty()) continue;
            atributos = atributos.substring(0, atributos.length() - 1);
            Query query = qb.keyword().onFields(atributos.split(",")).matching((Object)text).createQuery();
            aRetornar.addAll(fullTextEntityManager.createFullTextQuery(query, new Class[]{entidade}).getResultList());
        }
        return aRetornar;
    }

    public static List<Field> getTodosAtributos(Class classe) throws SecurityException {
        ArrayList<Field> aRetornar = new ArrayList<Field>();
        if (!classe.getSuperclass().equals(Object.class)) {
            aRetornar.addAll(GumgaUntypedRepository.getTodosAtributos(classe.getSuperclass()));
        }
        aRetornar.addAll(Arrays.asList(classe.getDeclaredFields()));
        return aRetornar;
    }

    private List<Class> getAllIndexedEntities() {
        ArrayList<Class> aRetornar = new ArrayList<Class>();
        Session session = (Session)this.em.unwrap(Session.class);
        SessionFactory sessionFactory = session.getSessionFactory();
        Map map = sessionFactory.getAllClassMetadata();
        for (String k : map.keySet()) {
            Class mappedClass = ((ClassMetadata)map.get(k)).getMappedClass();
            if (!mappedClass.isAnnotationPresent(Entity.class) || !mappedClass.isAnnotationPresent(Indexed.class)) continue;
            aRetornar.add(mappedClass);
        }
        return aRetornar;
    }
}

