/*
 * Decompiled with CFR 0.152.
 */
package io.gumga.application;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.EnumerablePropertySource;
import org.springframework.stereotype.Component;

@Component
public class GumgaManagerProperties {
    private final Map<String, Object> properties = new HashMap<String, Object>();
    @Autowired
    private ConfigurableEnvironment configurableEnvironment;

    @PostConstruct
    private void loadProperties() {
        this.configurableEnvironment.getPropertySources().forEach(propertySource -> {
            if (propertySource instanceof EnumerablePropertySource) {
                for (String key : ((EnumerablePropertySource)propertySource).getPropertyNames()) {
                    this.properties.put(key, propertySource.getProperty(key));
                }
            }
        });
    }

    public String getProperty(String key) {
        return this.properties.get(key).toString();
    }

    public String getProperty(String key, String defaultValue) {
        return this.properties.getOrDefault(key, defaultValue).toString();
    }

    private void addAll(Map<String, Object> properties) {
        this.properties.putAll(properties);
    }
}

