/*
 * Decompiled with CFR 0.152.
 */
package io.gumga.application.service;

import com.google.common.io.Files;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.TemplateExceptionHandler;
import io.gumga.core.exception.TemplateEngineException;
import io.gumga.core.service.GumgaAbstractTemplateEngineAdapter;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class GumgaFreemarkerTemplateEngineService
extends GumgaAbstractTemplateEngineAdapter {
    private static final Logger log = LoggerFactory.getLogger(GumgaFreemarkerTemplateEngineService.class);
    private static Configuration cfg;
    private String templateFolder;
    private String defaultEncoding;

    public GumgaFreemarkerTemplateEngineService() {
    }

    public GumgaFreemarkerTemplateEngineService(String templateFolder, String defaultEncoding) {
        this.templateFolder = templateFolder;
        this.defaultEncoding = defaultEncoding;
    }

    public void setTemplateFolder(String folder) {
        this.templateFolder = folder;
    }

    public void setDefaultEncoding(String encoding) {
        this.defaultEncoding = encoding;
    }

    public void parse(Map<String, Object> values, String template, Writer out) throws TemplateEngineException {
        try {
            if (cfg == null) {
                GumgaFreemarkerTemplateEngineService.initStatic();
            }
            Template t = cfg.getTemplate(template);
            t.process(values, out);
        }
        catch (TemplateException | IOException ex) {
            throw new TemplateEngineException(String.format("An error occurred while parsing the template - %s", template), ex);
        }
    }

    public String parse(Map<String, Object> values, String template) throws TemplateEngineException {
        StringWriter out = new StringWriter();
        this.parse(values, template, out);
        return out.toString();
    }

    public void init() throws TemplateEngineException {
        if (cfg == null) {
            try {
                this.checkFolder(this.templateFolder);
                URL resourceUrl = ((Object)((Object)this)).getClass().getResource("/templates");
                Path resourcePath = Paths.get(resourceUrl.toURI());
                for (File file : resourcePath.toFile().listFiles()) {
                    File destination = new File(this.templateFolder + File.separator + file.getName());
                    if (destination.exists()) continue;
                    Files.copy((File)file, (File)destination);
                }
                GumgaFreemarkerTemplateEngineService.initStatic();
                cfg.setDirectoryForTemplateLoading(new File(this.templateFolder));
                cfg.setDefaultEncoding(this.defaultEncoding);
                cfg.setTemplateExceptionHandler(TemplateExceptionHandler.RETHROW_HANDLER);
            }
            catch (IOException ex) {
                throw new TemplateEngineException("An error occurred while initializating the template engine", (Throwable)ex);
            }
            catch (URISyntaxException e) {
                throw new TemplateEngineException("An error occurred while initializating the template engine", (Throwable)e);
            }
            catch (FileSystemNotFoundException ex) {
                log.warn("------->Templates n\u00e3o encontrados." + ex);
            }
        }
    }

    private static synchronized void initStatic() {
        cfg = new Configuration(Configuration.VERSION_2_3_22);
    }
}

