/*
 * Decompiled with CFR 0.152.
 */
package io.gumga.application;

import io.gumga.application.service.AbstractGumgaService;
import io.gumga.core.GumgaIdable;
import io.gumga.core.QueryObject;
import io.gumga.core.SearchResult;
import io.gumga.domain.GumgaObjectAndRevision;
import io.gumga.domain.GumgaServiceable;
import io.gumga.domain.repository.GumgaCrudRepository;
import java.io.Serializable;
import java.util.List;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Scope(value="prototype")
public abstract class GumgaService<T extends GumgaIdable<ID>, ID extends Serializable>
extends AbstractGumgaService<T, ID>
implements GumgaServiceable<T, ID> {
    public GumgaService(GumgaCrudRepository<T, ID> repository) {
        super(repository);
    }

    public void beforePesquisa(QueryObject query) {
    }

    public void afterPesquisa(SearchResult<T> result) {
    }

    @Transactional(readOnly=true)
    public SearchResult<T> pesquisa(QueryObject query) {
        this.beforePesquisa(query);
        SearchResult result = this.repository.search(query);
        this.afterPesquisa(result);
        return result;
    }

    public void beforeView(ID id) {
    }

    public void afterView(T entity) {
    }

    @Transactional(readOnly=true)
    public T view(ID id) {
        this.beforeView(id);
        GumgaIdable entity = (GumgaIdable)this.repository.findOne(id);
        this.loadGumgaCustomFields(entity);
        this.afterView(entity);
        return (T)entity;
    }

    @Transactional(readOnly=true)
    public Object genercView(Class clazz, ID id) {
        Object entity = this.repository.genericFindOne(clazz, id);
        return entity;
    }

    public void beforeDelete(T entity) {
    }

    public void afterDelete() {
    }

    @Transactional
    public void delete(T resource) {
        this.beforeDelete(resource);
        this.repository.delete(resource);
        if (this.gces != null) {
            this.gces.deleteCustomFields((GumgaIdable)resource);
        }
        this.afterDelete();
    }

    @Transactional
    public void delete(List<T> list) {
        this.repository.delete(list);
        if (this.gces != null) {
            for (GumgaIdable e : list) {
                this.gces.deleteCustomFields(e);
            }
        }
        this.afterDelete();
    }

    private void beforeSaveOrUpdate(T entity, boolean isNew) {
        if (isNew) {
            this.beforeSave(entity);
        } else {
            this.beforeUpdate(entity);
        }
    }

    private void afterSaveOrUpdate(T entity, boolean isNew) {
        if (isNew) {
            this.afterSave(entity);
        } else {
            this.afterUpdate(entity);
        }
    }

    public void beforeSave(T entity) {
    }

    public void beforeUpdate(T entity) {
    }

    public void afterSave(T entity) {
    }

    public void afterUpdate(T entity) {
    }

    @Transactional
    public T save(T resource) {
        boolean isNew = resource.getId() == null;
        this.beforeSaveOrUpdate(resource, isNew);
        GumgaIdable entity = (GumgaIdable)this.repository.save(resource);
        if (this.gces != null) {
            this.gces.saveCustomFields((GumgaIdable)resource);
        }
        this.afterSaveOrUpdate(entity, isNew);
        return (T)entity;
    }

    public void forceFlush() {
        this.repository.flush();
    }

    @Transactional(readOnly=true)
    public List<GumgaObjectAndRevision> listOldVersions(ID id) {
        List oldVersions = this.repository.listOldVersions(id);
        return oldVersions;
    }
}

