/*
 * Decompiled with CFR 0.152.
 */
package io.gumga.application;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.gumga.application.GumgaFieldStereotype;
import io.gumga.application.GumgaGenericRepostoryHelperException;
import io.gumga.application.GumgaHqlElement;
import io.gumga.application.GumgaHqlEntry;
import io.gumga.core.QueryObjectElement;
import io.gumga.core.utils.ReflectionUtils;
import io.gumga.domain.GumgaQueryParserProvider;
import io.gumga.domain.domains.GumgaMoney;
import java.io.IOException;
import java.lang.reflect.Field;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringEscapeUtils;
import org.springframework.data.jpa.repository.support.JpaEntityInformation;

public class GumgaGenericRepositoryHelper {
    private static Map<GumgaHqlEntry, GumgaHqlElement> hqlConverter;

    private GumgaGenericRepositoryHelper() {
    }

    public static Map<GumgaHqlEntry, GumgaHqlElement> getHqlConverter() {
        if (hqlConverter == null) {
            hqlConverter = new HashMap<GumgaHqlEntry, GumgaHqlElement>();
            hqlConverter.put(new GumgaHqlEntry(GumgaFieldStereotype.DEFAULT, "eq"), new GumgaHqlElement("='", "'"));
            hqlConverter.put(new GumgaHqlEntry(GumgaFieldStereotype.DEFAULT, "ne"), new GumgaHqlElement("!='", "'"));
            hqlConverter.put(new GumgaHqlEntry(GumgaFieldStereotype.DEFAULT, "ge"), new GumgaHqlElement(">='", "'"));
            hqlConverter.put(new GumgaHqlEntry(GumgaFieldStereotype.DEFAULT, "le"), new GumgaHqlElement("<='", "'"));
            hqlConverter.put(new GumgaHqlEntry(GumgaFieldStereotype.DEFAULT, "gt"), new GumgaHqlElement(">'", "'"));
            hqlConverter.put(new GumgaHqlEntry(GumgaFieldStereotype.DEFAULT, "lt"), new GumgaHqlElement("<'", "'"));
            hqlConverter.put(new GumgaHqlEntry(GumgaFieldStereotype.DEFAULT, "contains"), new GumgaHqlElement(" like '%", "%'"));
            hqlConverter.put(new GumgaHqlEntry(GumgaFieldStereotype.DEFAULT, "not_contains"), new GumgaHqlElement(" not like '%", "%'"));
            hqlConverter.put(new GumgaHqlEntry(GumgaFieldStereotype.DEFAULT, "starts_with"), new GumgaHqlElement(" like '", "%'"));
            hqlConverter.put(new GumgaHqlEntry(GumgaFieldStereotype.DEFAULT, "ends_with"), new GumgaHqlElement(" like '%", "'"));
            hqlConverter.put(new GumgaHqlEntry(GumgaFieldStereotype.TEXT, "contains"), new GumgaHqlElement(" like '%", "%'"));
            hqlConverter.put(new GumgaHqlEntry(GumgaFieldStereotype.TEXT, "not_contains"), new GumgaHqlElement(" not like '%", "%'"));
            hqlConverter.put(new GumgaHqlEntry(GumgaFieldStereotype.TEXT, "starts_with"), new GumgaHqlElement(" like '", "%'"));
            hqlConverter.put(new GumgaHqlEntry(GumgaFieldStereotype.TEXT, "ends_with"), new GumgaHqlElement(" like '%", "'"));
            hqlConverter.put(new GumgaHqlEntry(GumgaFieldStereotype.NUMBER, "eq"), new GumgaHqlElement("=", ""));
            hqlConverter.put(new GumgaHqlEntry(GumgaFieldStereotype.NUMBER, "ne"), new GumgaHqlElement("!=", ""));
            hqlConverter.put(new GumgaHqlEntry(GumgaFieldStereotype.NUMBER, "ge"), new GumgaHqlElement(">=", ""));
            hqlConverter.put(new GumgaHqlEntry(GumgaFieldStereotype.NUMBER, "le"), new GumgaHqlElement("<=", ""));
            hqlConverter.put(new GumgaHqlEntry(GumgaFieldStereotype.NUMBER, "gt"), new GumgaHqlElement(">", ""));
            hqlConverter.put(new GumgaHqlEntry(GumgaFieldStereotype.NUMBER, "lt"), new GumgaHqlElement("<", ""));
        }
        return hqlConverter;
    }

    public static String getHql(QueryObjectElement qoe) {
        if ("string".equals(qoe.getAttributeType())) {
            GumgaHqlElement ghe = GumgaGenericRepositoryHelper.getHqlConverter().get(new GumgaHqlEntry(GumgaFieldStereotype.TEXT, qoe.getHql().trim()));
            return "obj." + qoe.getAttribute() + ghe.before + qoe.getValue() + ghe.after;
        }
        GumgaHqlElement ghe = GumgaGenericRepositoryHelper.getHqlConverter().get(new GumgaHqlEntry(GumgaFieldStereotype.DEFAULT, qoe.getHql().trim()));
        return "obj." + qoe.getAttribute() + ghe.before + qoe.getValue() + ghe.after;
    }

    public static GumgaFieldStereotype getFieldStereotype(Class type) {
        if (String.class.equals((Object)type)) {
            return GumgaFieldStereotype.TEXT;
        }
        if (Byte.class.equals((Object)type)) {
            return GumgaFieldStereotype.NUMBER;
        }
        if (Double.class.equals((Object)type)) {
            return GumgaFieldStereotype.NUMBER;
        }
        if (Float.class.equals((Object)type)) {
            return GumgaFieldStereotype.NUMBER;
        }
        if (Integer.class.equals((Object)type)) {
            return GumgaFieldStereotype.NUMBER;
        }
        if (Long.class.equals((Object)type)) {
            return GumgaFieldStereotype.NUMBER;
        }
        if (Number.class.equals((Object)type)) {
            return GumgaFieldStereotype.NUMBER;
        }
        if (Short.class.equals((Object)type)) {
            return GumgaFieldStereotype.NUMBER;
        }
        if (GumgaMoney.class.equals((Object)type)) {
            return GumgaFieldStereotype.NUMBER;
        }
        return GumgaFieldStereotype.DEFAULT;
    }

    public static List<QueryObjectElement> qoeFromString(String s) {
        ArrayList<QueryObjectElement> aRetornar = new ArrayList<QueryObjectElement>();
        try {
            ObjectMapper mapper = new ObjectMapper();
            JsonNode mainNode = mapper.readTree(s);
            Iterator elements = mainNode.elements();
            while (elements.hasNext()) {
                QueryObjectElement qoe = new QueryObjectElement();
                aRetornar.add(qoe);
                JsonNode node = (JsonNode)elements.next();
                System.out.println("---->" + node);
                if (node.has("attribute")) {
                    qoe.setAttribute(node.get("attribute").get("field").asText());
                    qoe.setAttributeType(node.get("attribute").get("type").asText());
                }
                if (node.has("condition")) {
                    qoe.setHql(node.get("condition").get("hql").asText());
                }
                qoe.setValue(node.get("value").asText());
            }
        }
        catch (IOException ex) {
            throw new GumgaGenericRepostoryHelperException(ex);
        }
        System.out.println();
        return aRetornar;
    }

    public static String hqlFromQoes(JpaEntityInformation entityInformation, List<QueryObjectElement> qoes) {
        String aRetornar = "";
        for (QueryObjectElement qoe : qoes) {
            if ("NO_ATTRIBUTE".equals(qoe.getAttribute())) {
                aRetornar = aRetornar + " " + qoe.getValue() + " ";
                continue;
            }
            Class type = String.class;
            Field field = ReflectionUtils.findField((Class)entityInformation.getJavaType(), (String)qoe.getAttribute());
            if (field != null) {
                type = field.getType();
            }
            GumgaFieldStereotype fieldStereotype = GumgaGenericRepositoryHelper.getFieldStereotype(type);
            aRetornar = GumgaQueryParserProvider.defaultMap.equals(GumgaQueryParserProvider.getOracleLikeMap()) && fieldStereotype == GumgaFieldStereotype.TEXT ? aRetornar + "upper(translate(obj." + qoe.getAttribute() + ",'" + "\u00e2\u00e0\u00e3\u00e1\u00c1\u00c2\u00c0\u00c3\u00e9\u00ea\u00c9\u00ca\u00ed\u00cd\u00f3\u00f4\u00f5\u00d3\u00d4\u00d5\u00fc\u00fa\u00dc\u00da\u00c7\u00e7" + "','" + "AAAAAAAAEEEEIIOOOOOOUUUUCC" + "'))" : aRetornar + "obj." + qoe.getAttribute();
            GumgaHqlEntry het = new GumgaHqlEntry(fieldStereotype, qoe.getHql());
            GumgaHqlElement hel = GumgaGenericRepositoryHelper.getHqlConverter().get(het);
            aRetornar = aRetornar + hel.before + GumgaGenericRepositoryHelper.removeAcentos(qoe.getValue()).toUpperCase() + hel.after;
        }
        return aRetornar;
    }

    public static String removeAcentos(String str) {
        str = Normalizer.normalize(str, Normalizer.Form.NFD);
        str = str.replaceAll("[^\\p{ASCII}]", "");
        return str;
    }

    public static String hql(String aqo) {
        aqo = StringEscapeUtils.unescapeJavaScript((String)aqo);
        aqo = aqo.substring(1, aqo.length() - 1);
        List<QueryObjectElement> qoeFromString = GumgaGenericRepositoryHelper.qoeFromString(aqo);
        String hql = "";
        for (QueryObjectElement e : qoeFromString) {
            hql = hql + (e.isLogical() ? e.toString() : GumgaGenericRepositoryHelper.getHql(e));
        }
        return hql;
    }

    public static String hql(List<QueryObjectElement> qoes) {
        String hql = "";
        for (QueryObjectElement e : qoes) {
            hql = hql + (e.isLogical() ? e.toString() : GumgaGenericRepositoryHelper.getHql(e));
        }
        return hql;
    }

    public static void main(String[] args) {
        String aqo = "\"[{\\\"attribute\\\":{\\\"field\\\":\\\"name\\\",\\\"type\\\":\\\"string\\\",\\\"label\\\":\\\"Nome\\\"},\\\"condition\\\":{\\\"hql\\\":\\\" contains \\\",\\\"label\\\":\\\" cont\u00e9m \\\",\\\"before\\\":\\\" like '%\\\",\\\"after\\\":\\\"%'\\\"},\\\"value\\\":\\\"Gum\\\"},{\\\"value\\\":\\\"AND\\\"},{\\\"attribute\\\":{\\\"field\\\":\\\"id\\\",\\\"type\\\":\\\"number\\\",\\\"label\\\":\\\"Id\\\"},\\\"condition\\\":{\\\"hql\\\":\\\" gt \\\",\\\"label\\\":\\\" maior que \\\",\\\"before\\\":\\\" >   \\\",\\\"after\\\":\\\"\\\"},\\\"value\\\":2}]\"";
        System.out.println(GumgaGenericRepositoryHelper.hql(aqo));
    }
}

