/*
 * Decompiled with CFR 0.152.
 */
package io.gumga.application.service;

import io.gumga.application.service.ReportType;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperExportManager;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.data.JRBeanCollectionDataSource;
import net.sf.jasperreports.engine.util.JRLoader;
import org.springframework.stereotype.Service;

@Service(value="reportService")
public class JasperReportService {
    public JasperPrint generateReport(InputStream reportStream, List data, Map<String, Object> params) throws JRException, IOException {
        if (data == null) {
            data = Collections.emptyList();
        }
        if (params == null) {
            params = new HashMap<String, Object>();
        }
        JasperReport jasperReport = (JasperReport)JRLoader.loadObject((InputStream)reportStream);
        JasperPrint jasperPrint = JasperFillManager.fillReport((JasperReport)jasperReport, params, (JRDataSource)new JRBeanCollectionDataSource(data));
        return jasperPrint;
    }

    public void exportReportToHtmlFile(InputStream reportStream, List data, Map<String, Object> params, String destFile) throws JRException, IOException {
        JasperPrint jp = this.generateReport(reportStream, data, params);
        JasperExportManager.exportReportToHtmlFile((JasperPrint)jp, (String)destFile);
    }

    public void exportReport(InputStream reportStream, OutputStream outStream, List data, Map<String, Object> params, ReportType type) throws JRException, IOException {
        if (!ReportType.HTML.equals((Object)type)) {
            JasperPrint jasperPrint = this.generateReport(reportStream, data, params);
            switch (type) {
                case PDF: {
                    JasperExportManager.exportReportToPdfStream((JasperPrint)jasperPrint, (OutputStream)outStream);
                    break;
                }
                default: {
                    JasperExportManager.exportReportToXmlStream((JasperPrint)jasperPrint, (OutputStream)outStream);
                }
            }
        }
    }
}

