/*
 * Decompiled with CFR 0.152.
 */
package io.gumga.application.seed;

import io.gumga.application.GumgaService;
import io.gumga.core.GumgaIdable;
import io.gumga.domain.seed.AppSeed;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import org.springframework.transaction.annotation.Transactional;

public abstract class AbstractSeed<T extends GumgaIdable<ID>, ID extends Serializable>
implements AppSeed {
    @Transactional
    public void loadSeed() throws IOException {
        String line;
        URL url = Thread.currentThread().getContextClassLoader().getResource(this.pathFile());
        if (url == null) {
            throw new FileNotFoundException();
        }
        File file = new File(url.getFile());
        BufferedReader source = new BufferedReader(new FileReader(file));
        int count = 0;
        while ((line = source.readLine()) != null) {
            String[] parts = line.split(";");
            this.service().save(this.createObject(parts));
            if (++count != 50) continue;
            this.service().forceFlush();
            count = 0;
        }
        source.close();
    }

    public abstract GumgaService<T, ID> service();

    public abstract T createObject(String[] var1);

    public abstract String pathFile();
}

