/*
 * Decompiled with CFR 0.152.
 */
package io.gumga.application.tag;

import io.gumga.application.GumgaService;
import io.gumga.application.tag.GumgaTagRepository;
import io.gumga.core.GumgaIdable;
import io.gumga.core.QueryObject;
import io.gumga.domain.tag.GumgaTag;
import io.gumga.domain.tag.GumgaTagDefinition;
import java.util.List;
import javax.transaction.Transactional;
import org.hibernate.Hibernate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class GumgaTagService
extends GumgaService<GumgaTag, Long> {
    private GumgaTagRepository repository;

    @Autowired
    public GumgaTagService(GumgaTagRepository repository) {
        super(repository);
        this.repository = repository;
    }

    @Transactional
    public GumgaTag loadGumgaTagFat(Long id) {
        GumgaTag obj = (GumgaTag)this.repository.findOne(id);
        Hibernate.initialize((Object)obj.getValues());
        return obj;
    }

    public GumgaTag createNew(GumgaTagDefinition tagDef, String objectType, Long objectId) {
        GumgaTag tag = new GumgaTag(tagDef);
        tag.setObjectType(objectType);
        tag.setObjectId(objectId);
        return tag;
    }

    @Transactional
    public List<GumgaTag> findByObjectTypeAndObjectId(String objectType, Long objectId) {
        QueryObject qo = new QueryObject();
        qo.setAq("obj.objectType='" + objectType + "' AND obj.objectId=" + objectId);
        return this.repository.search(qo).getValues();
    }

    @Transactional
    public List<GumgaTag> findByObject(GumgaIdable<Long> obj) {
        return this.findByObjectTypeAndObjectId(obj.getClass().getName(), (Long)obj.getId());
    }
}

