/*
 * Decompiled with CFR 0.152.
 */
package io.gumga.application.spring.config;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import io.gumga.application.spring.config.DataSourceProvider;
import io.gumga.domain.GumgaQueryParserProvider;
import javax.sql.DataSource;

public class MySqlDataSourceProvider
implements DataSourceProvider {
    @Override
    public DataSource createDataSource(String url, String user, String password) {
        return this.createDataSource(url, user, password, 5, 20);
    }

    @Override
    public DataSource createDataSource(String url, String user, String password, int minConnections, int maxConnections) {
        MySqlDataSourceProvider.initDefaultMap();
        HikariConfig config = new HikariConfig();
        config.setDataSourceClassName("com.mysql.jdbc.jdbc2.optional.MysqlDataSource");
        config.addDataSourceProperty("url", (Object)url);
        config.addDataSourceProperty("user", (Object)user);
        config.addDataSourceProperty("password", (Object)password);
        config.setMinimumIdle(minConnections);
        config.setMaximumPoolSize(maxConnections);
        config.setIdleTimeout(30000L);
        config.setInitializationFailFast(true);
        return new HikariDataSource(config);
    }

    @Override
    public String getDialect() {
        return "org.hibernate.dialect.MySQLDialect";
    }

    public static synchronized void initDefaultMap() {
        GumgaQueryParserProvider.defaultMap = GumgaQueryParserProvider.getMySqlLikeMap();
    }
}

