/*
 * Decompiled with CFR 0.152.
 */
package io.gumga.application.service;

import io.gumga.application.service.AbstractGumgaService;
import io.gumga.core.GumgaIdable;
import io.gumga.core.QueryObject;
import io.gumga.core.SearchResult;
import io.gumga.domain.repository.GumgaCrudRepository;
import io.gumga.domain.service.GumgaReadableServiceable;
import java.io.Serializable;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Scope(value="prototype")
public abstract class GumgaReadOnlyService<T extends GumgaIdable<?>, ID extends Serializable>
extends AbstractGumgaService<T, ID>
implements GumgaReadableServiceable<T> {
    public GumgaReadOnlyService(GumgaCrudRepository<T, ID> repository) {
        super(repository);
    }

    public void beforePesquisa(QueryObject query) {
    }

    public void afterPesquisa(SearchResult<T> result) {
    }

    @Transactional(readOnly=true)
    public SearchResult<T> pesquisa(QueryObject query) {
        this.beforePesquisa(query);
        SearchResult result = this.repository.search(query);
        this.afterPesquisa(result);
        return result;
    }

    public void beforeView(ID id) {
    }

    public void afterView(T entity) {
    }

    @Transactional(readOnly=true)
    public T view(ID id) {
        this.beforeView(id);
        GumgaIdable entity = (GumgaIdable)this.repository.findOne(id);
        this.loadGumgaCustomFields(entity);
        this.afterView(entity);
        return (T)entity;
    }

    @Transactional(readOnly=true)
    public Object genercView(Class clazz, ID id) {
        Object entity = this.repository.genericFindOne(clazz, id);
        return entity;
    }
}

