/*
 * Decompiled with CFR 0.152.
 */
package io.gumga.application;

import io.gumga.core.GumgaValues;
import io.gumga.domain.domains.GumgaFile;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Random;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class GumgaTempFileService {
    private static final Logger log = LoggerFactory.getLogger(GumgaTempFileService.class);
    @Autowired
    private GumgaValues gumgaValues;

    public String create(GumgaFile gumgaFile) {
        String tempFileName = "uploadData" + (System.currentTimeMillis() * 1000L + (long)new Random().nextInt(1000));
        try {
            File folder = new File(this.gumgaValues.getUploadTempDir());
            folder.mkdirs();
            FileOutputStream fos = new FileOutputStream(this.gumgaValues.getUploadTempDir() + "/" + tempFileName);
            ObjectOutputStream oos = new ObjectOutputStream(fos);
            oos.writeObject(gumgaFile);
            oos.close();
            fos.close();
            return tempFileName;
        }
        catch (Exception ex) {
            log.error("erro ao criar arquivo temporario " + tempFileName, (Throwable)ex);
            return "error";
        }
    }

    public String delete(String fileName) {
        try {
            File file = new File(this.gumgaValues.getUploadTempDir() + "/" + fileName);
            file.delete();
            return "OK";
        }
        catch (Exception ex) {
            log.error("erro ao excluir arquivo temporario " + fileName, (Throwable)ex);
            return "error";
        }
    }

    public GumgaFile find(String tempFileName) {
        if (tempFileName == null || tempFileName.isEmpty()) {
            return null;
        }
        try {
            FileInputStream fis = new FileInputStream(this.gumgaValues.getUploadTempDir() + "/" + tempFileName);
            ObjectInputStream ois = new ObjectInputStream(fis);
            GumgaFile gf = (GumgaFile)ois.readObject();
            ois.close();
            fis.close();
            return gf;
        }
        catch (Exception ex) {
            log.error("erro ao recuperar arquivo temporario " + tempFileName, (Throwable)ex);
            return null;
        }
    }
}

