/*
 * Decompiled with CFR 0.152.
 */
package io.gumga.application;

import io.gumga.application.GumgaCrudAndQueryNotOnlyTypedRepositoryImpl;
import io.gumga.application.GumgaGenericRepository;
import io.gumga.application.GumgaQueryDSLRepositoryImpl;
import io.gumga.domain.repository.GumgaCrudAndQueryNotOnlyTypedRepository;
import io.gumga.domain.repository.GumgaCrudRepository;
import io.gumga.domain.repository.GumgaQueryDSLRepository;
import java.io.Serializable;
import javax.persistence.EntityManager;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.support.JpaEntityInformationSupport;
import org.springframework.data.jpa.repository.support.JpaRepositoryFactory;
import org.springframework.data.jpa.repository.support.JpaRepositoryFactoryBean;
import org.springframework.data.querydsl.QueryDslPredicateExecutor;
import org.springframework.data.querydsl.QueryDslUtils;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.core.support.RepositoryFactorySupport;

public class GumgaRepositoryFactoryBean<R extends JpaRepository<T, I>, T, I extends Serializable>
extends JpaRepositoryFactoryBean<R, T, I> {
    protected RepositoryFactorySupport createRepositoryFactory(EntityManager entityManager) {
        return new MyRepositoryFactory(entityManager);
    }

    private static boolean isQueryDslExecutor(Class<?> repositoryInterface) {
        return QueryDslUtils.QUERY_DSL_PRESENT && QueryDslPredicateExecutor.class.isAssignableFrom(repositoryInterface);
    }

    private static boolean isQueryNoTyped(Class<?> repositoryInterface) {
        return GumgaCrudAndQueryNotOnlyTypedRepository.class.isAssignableFrom(repositoryInterface);
    }

    private static class MyRepositoryFactory<T, I extends Serializable>
    extends JpaRepositoryFactory {
        private final EntityManager entityManager;

        public MyRepositoryFactory(EntityManager entityManager) {
            super(entityManager);
            this.entityManager = entityManager;
        }

        protected Object getTargetRepository(RepositoryMetadata metadata) {
            Class repositoryInterface = metadata.getRepositoryInterface();
            Class domainClass = metadata.getDomainType();
            if (GumgaRepositoryFactoryBean.isQueryDslExecutor(repositoryInterface)) {
                return new GumgaQueryDSLRepositoryImpl(JpaEntityInformationSupport.getMetadata((Class)domainClass, (EntityManager)this.entityManager), this.entityManager);
            }
            if (GumgaRepositoryFactoryBean.isQueryNoTyped(repositoryInterface)) {
                return new GumgaCrudAndQueryNotOnlyTypedRepositoryImpl(JpaEntityInformationSupport.getMetadata((Class)domainClass, (EntityManager)this.entityManager), this.entityManager);
            }
            return new GumgaGenericRepository(JpaEntityInformationSupport.getMetadata((Class)domainClass, (EntityManager)this.entityManager), this.entityManager);
        }

        protected Class<?> getRepositoryBaseClass(RepositoryMetadata metadata) {
            if (GumgaRepositoryFactoryBean.isQueryDslExecutor(metadata.getRepositoryInterface())) {
                return GumgaQueryDSLRepository.class;
            }
            if (GumgaRepositoryFactoryBean.isQueryNoTyped(metadata.getRepositoryInterface())) {
                return GumgaCrudAndQueryNotOnlyTypedRepository.class;
            }
            return GumgaCrudRepository.class;
        }
    }
}

