/*
 * Decompiled with CFR 0.152.
 */
package io.gumga.application;

import com.mysema.query.jpa.JPQLQuery;
import com.mysema.query.types.EntityPath;
import com.mysema.query.types.Expression;
import com.mysema.query.types.OrderSpecifier;
import com.mysema.query.types.PathMetadataFactory;
import com.mysema.query.types.Predicate;
import com.mysema.query.types.expr.BooleanExpression;
import com.mysema.query.types.path.ComparablePath;
import com.mysema.query.types.path.PathBuilder;
import io.gumga.application.GumgaGenericRepository;
import io.gumga.core.SearchResult;
import io.gumga.core.TenancyPublicMarking;
import io.gumga.domain.GumgaMultitenancy;
import io.gumga.domain.domains.GumgaOi;
import io.gumga.domain.repository.GumgaMultitenancyUtil;
import io.gumga.domain.repository.GumgaQueryDSLRepository;
import io.gumga.domain.repository.ISpecification;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import javax.persistence.EntityManager;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.repository.support.JpaEntityInformation;
import org.springframework.data.jpa.repository.support.Querydsl;
import org.springframework.data.querydsl.QSort;
import org.springframework.data.querydsl.SimpleEntityPathResolver;
import org.springframework.data.repository.NoRepositoryBean;

@NoRepositoryBean
public class GumgaQueryDSLRepositoryImpl<T, ID extends Serializable>
extends GumgaGenericRepository<T, ID>
implements GumgaQueryDSLRepository<T, ID> {
    private final EntityPath<T> path;
    private final Querydsl querydsl;

    public GumgaQueryDSLRepositoryImpl(JpaEntityInformation<T, ID> entityInformation, EntityManager entityManager) {
        super(entityInformation, entityManager);
        this.path = SimpleEntityPathResolver.INSTANCE.createPath(entityInformation.getJavaType());
        PathBuilder builder = new PathBuilder(this.path.getType(), this.path.getMetadata());
        this.querydsl = new Querydsl(entityManager, builder);
    }

    @Override
    public T findOne(Predicate predicate) {
        return (T)this.createQuery(predicate).uniqueResult(this.path);
    }

    @Override
    public List<T> findAll() {
        return this.createQuery(new Predicate[0]).list(this.path);
    }

    public List<T> findAll(Predicate predicate) {
        return this.findAll(this.toSpecification(predicate), (Expression)this.path);
    }

    public List<T> findAll(Predicate predicate, OrderSpecifier<?> ... orders) {
        JPQLQuery query = this.createQuery(predicate);
        query = this.querydsl.applySorting((Sort)new QSort(orders), query);
        return query.list(this.path);
    }

    public List<T> findAll(ISpecification specification) {
        return this.findAll(specification, (Expression)this.path);
    }

    public <A> List<A> findAll(ISpecification specification, Expression<A> projection) {
        return this.createQuery(specification).list(projection);
    }

    public Page<T> findAll(ISpecification specification, Pageable page) {
        return this.findAll(specification, page, (Expression)this.path);
    }

    public <A> Page<A> findAll(ISpecification specification, Pageable page, Expression<A> projection) {
        long total = this.createQuery(specification).count();
        JPQLQuery query = this.createQuery(specification);
        query = this.querydsl.applyPagination(page, query);
        List content = total > (long)page.getOffset() ? query.list(projection) : Collections.emptyList();
        return new PageImpl(content, page, total);
    }

    public SearchResult<T> search(Predicate predicate, Pageable page) {
        return this.search(this.toSpecification(predicate), page);
    }

    public <A> SearchResult<A> search(Predicate predicate, Pageable page, Expression<A> projection) {
        return this.search(this.toSpecification(predicate), page, projection);
    }

    public SearchResult<T> search(ISpecification specification, Pageable page) {
        return this.search(specification, page, (Expression)this.path);
    }

    public <A> SearchResult<A> search(ISpecification specification, Pageable page, Expression<A> projection) {
        return this.createResultFromPageResult(page, this.findAll(specification, page, projection));
    }

    public <A> A findOne(ISpecification specification, Expression<A> projection) {
        return (A)specification.createQuery((JPQLQuery)this.querydsl.createQuery(new EntityPath[]{this.path})).uniqueResult(projection);
    }

    public Page<T> findAll(Predicate predicate, Pageable pageable) {
        return this.findAll(this.toSpecification(predicate), pageable, (Expression)this.path);
    }

    public long count(Predicate predicate) {
        return this.createQuery(predicate).count();
    }

    private <A> SearchResult<A> createResultFromPageResult(Pageable page, Page<A> result) {
        return new SearchResult(page.getOffset(), page.getPageSize(), (Number)result.getTotalElements(), result.getContent());
    }

    public JPQLQuery createQuery(Predicate ... predicate) {
        return this.createQuery(this.toSpecification(predicate));
    }

    private ISpecification toSpecification(Predicate ... predicate) {
        return query -> (JPQLQuery)query.where(predicate);
    }

    private JPQLQuery createQuery(ISpecification specification) {
        JPQLQuery query = specification.createQuery((JPQLQuery)this.querydsl.createQuery(new EntityPath[]{this.path}));
        if (this.hasMultitenancy()) {
            query.where(new Predicate[]{this.getOiExpression()});
        }
        return query;
    }

    private BooleanExpression getOiExpression() {
        GumgaMultitenancy tenancy = this.getDomainClass().getAnnotation(GumgaMultitenancy.class);
        String oiPattern = GumgaMultitenancyUtil.getMultitenancyPattern((GumgaMultitenancy)tenancy);
        ComparablePath oi = new ComparablePath(GumgaOi.class, PathMetadataFactory.forProperty(this.path, (String)"oi"));
        if (tenancy.allowPublics()) {
            if (tenancy.publicMarking().equals((Object)TenancyPublicMarking.NULL)) {
                return oi.stringValue().startsWith(oiPattern).or((Predicate)oi.isNull());
            }
            return oi.stringValue().startsWith(oiPattern).or((Predicate)oi.eq((Object)GumgaOi.MARK_PUBLIC));
        }
        return oi.stringValue().startsWith(oiPattern);
    }
}

