/*
 * Decompiled with CFR 0.152.
 */
package io.gumga.application.customfields;

import io.gumga.application.customfields.GumgaCustomFieldService;
import io.gumga.application.customfields.GumgaCustomFieldValueService;
import io.gumga.core.GumgaIdable;
import io.gumga.domain.GumgaModel;
import io.gumga.domain.customfields.GumgaCustomField;
import io.gumga.domain.customfields.GumgaCustomFieldValue;
import io.gumga.domain.customfields.GumgaCustomizableModel;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class GumgaCustomEnhancerService {
    @Autowired
    private GumgaCustomFieldService customFieldService;
    @Autowired
    private GumgaCustomFieldValueService customFieldValueService;

    public void setDefaultValues(Object object) {
        if (!(object instanceof GumgaCustomizableModel)) {
            return;
        }
        GumgaCustomizableModel gumgaCustomizable = (GumgaCustomizableModel)object;
        List<GumgaCustomField> customFields = this.customFieldService.findByClass(gumgaCustomizable.getClass());
        for (GumgaCustomField cf : customFields) {
            GumgaCustomFieldValue newValue = this.newValue(cf);
            gumgaCustomizable.getGumgaCustomFields().put(cf.getName(), newValue);
        }
    }

    public GumgaCustomFieldValue newValue(GumgaCustomField cf) {
        return new GumgaCustomFieldValue(cf);
    }

    public void loadCustomFields(Object gumgaModel) {
        if (!(gumgaModel instanceof GumgaCustomizableModel)) {
            return;
        }
        GumgaCustomizableModel gumgaCustomizable = (GumgaCustomizableModel)gumgaModel;
        List<GumgaCustomField> customFields = this.customFieldService.findByClass(gumgaModel.getClass());
        for (GumgaCustomField cf : customFields) {
            Object value = this.customFieldValueService.getValue(cf, (GumgaModel)gumgaModel);
            if (value == null) {
                value = this.newValue(cf);
            }
            gumgaCustomizable.getGumgaCustomFields().put(cf.getName(), value);
        }
    }

    public void saveCustomFields(GumgaIdable gumgaModel) {
        if (!(gumgaModel instanceof GumgaCustomizableModel)) {
            return;
        }
        GumgaCustomizableModel gumgaCustomizable = (GumgaCustomizableModel)gumgaModel;
        Set keySet = gumgaCustomizable.getGumgaCustomFields().keySet();
        for (String s : keySet) {
            GumgaCustomFieldValue value = (GumgaCustomFieldValue)gumgaCustomizable.getGumgaCustomFields().get(s);
            if (value == null) continue;
            value.setGumgaModelId((Long)gumgaModel.getId());
            this.customFieldValueService.save(value);
        }
    }

    public void deleteCustomFields(GumgaIdable gumgaModel) {
        if (!(gumgaModel instanceof GumgaCustomizableModel)) {
            return;
        }
        GumgaCustomizableModel gumgaCustomizable = (GumgaCustomizableModel)gumgaModel;
        Set keySet = gumgaCustomizable.getGumgaCustomFields().keySet();
        for (String s : keySet) {
            GumgaCustomFieldValue value = (GumgaCustomFieldValue)gumgaCustomizable.getGumgaCustomFields().get(s);
            if (value == null) continue;
            this.customFieldValueService.delete(value);
        }
    }
}

